/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ReaderWriterHandlerFluids
implements IReaderWriterHandler {
    public static final String ID = "fluids";
    private FluidTank tank = new FluidTank(4000);
    private FluidTankReaderWriter tankReader = new FluidTankReaderWriter(this.tank, true, false);
    private FluidTankReaderWriter tankWriter = new FluidTankReaderWriter(this.tank, false, true);

    public ReaderWriterHandlerFluids(@Nullable NBTTagCompound tag) {
        if (tag != null) {
            this.tank.readFromNBT(tag);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapabilityReader(IReader reader, Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapabilityReader(IReader reader, Capability<T> capability) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankReader);
        }
        return null;
    }

    @Override
    public boolean hasCapabilityWriter(IWriter writer, Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapabilityWriter(IWriter writer, Capability<T> capability) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankWriter);
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<ITextComponent> getStatusReader(IReader reader, IReaderWriterChannel channel) {
        return this.getStatus(this.tankReader);
    }

    @Override
    public List<ITextComponent> getStatusWriter(IWriter writer, IReaderWriterChannel channel) {
        return this.getStatus(this.tankWriter);
    }

    private List<ITextComponent> getStatus(IFluidTank tank) {
        FluidStack stack = tank.getFluid();
        if (stack == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TextComponentString(RenderUtils.QUANTITY_FORMATTER.format((float)stack.amount / 1000.0f) + "x ").func_150257_a((ITextComponent)new TextComponentTranslation(stack.getUnlocalizedName(), new Object[0])));
    }

    private class FluidTankReaderWriter
    implements IFluidTank,
    IFluidHandler {
        private FluidTank parent;
        private boolean canFill;
        private boolean canDrain;
        private IFluidTankProperties[] properties;

        public FluidTankReaderWriter(final FluidTank parent, final boolean canFill, final boolean canDrain) {
            this.parent = parent;
            this.canFill = canFill;
            this.canDrain = canDrain;
            this.properties = new IFluidTankProperties[]{new IFluidTankProperties(){

                @Nullable
                public FluidStack getContents() {
                    return parent.getFluid();
                }

                public int getCapacity() {
                    return parent.getCapacity();
                }

                public boolean canFill() {
                    return canFill;
                }

                public boolean canDrain() {
                    return canDrain;
                }

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return canFill;
                }

                public boolean canDrainFluidType(FluidStack fluidStack) {
                    return canDrain;
                }
            }};
        }

        @Nullable
        public FluidStack getFluid() {
            return this.parent.getFluid();
        }

        public int getFluidAmount() {
            return this.parent.getFluidAmount();
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.parent.getInfo();
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.canFill ? this.parent.fill(resource, doFill) : 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.canDrain ? this.parent.drain(resource, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.canDrain ? this.parent.drain(maxDrain, doDrain) : null;
        }
    }
}

