/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.readerwriter;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ReaderWriterHandlerItems
implements IReaderWriterHandler {
    public static final String ID = "items";
    private ItemStackHandler items = new ItemStackHandler(4);
    private ItemHandlerReaderWriter itemsReader;
    private ItemHandlerReaderWriter itemsWriter = new ItemHandlerReaderWriter((IItemHandler)this.items, false, true);

    public ReaderWriterHandlerItems(@Nullable NBTTagCompound tag) {
        this.itemsReader = new ItemHandlerReaderWriter((IItemHandler)this.items, true, false);
        if (tag != null) {
            StackUtils.readItems((IItemHandlerModifiable)this.items, 0, tag);
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapabilityReader(IReader reader, Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapabilityReader(IReader reader, Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemsReader);
        }
        return null;
    }

    @Override
    public boolean hasCapabilityWriter(IWriter writer, Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapabilityWriter(IWriter writer, Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemsWriter);
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        StackUtils.writeItems((IItemHandler)this.items, 0, tag);
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<ITextComponent> getStatusReader(IReader reader, IReaderWriterChannel channel) {
        return this.getStatus(this.itemsReader);
    }

    @Override
    public List<ITextComponent> getStatusWriter(IWriter writer, IReaderWriterChannel channel) {
        return this.getStatus(this.itemsWriter);
    }

    private List<ITextComponent> getStatus(IItemHandler handler) {
        ArrayList<ITextComponent> components = new ArrayList<ITextComponent>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            components.add(new TextComponentString(stack.func_190916_E() + "x ").func_150257_a((ITextComponent)new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0])));
        }
        return components;
    }

    private class ItemHandlerReaderWriter
    implements IItemHandler {
        private IItemHandler parent;
        private boolean canInsert;
        private boolean canExtract;

        public ItemHandlerReaderWriter(IItemHandler parent, boolean canInsert, boolean canExtract) {
            this.parent = parent;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        public int getSlots() {
            return this.parent.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.canInsert ? this.parent.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canExtract ? this.parent.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot);
        }
    }
}

