/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.security;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCard;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCardContainer;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityManager;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.UserListOps;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SecurityManager
implements ISecurityManager {
    private INetwork network;
    private Map<UUID, ISecurityCard> cards = new HashMap<UUID, ISecurityCard>();

    public SecurityManager(INetwork network) {
        this.network = network;
    }

    @Override
    public boolean hasPermission(Permission permission, EntityPlayer player) {
        UserListOps ops = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m();
        if (this.cards.isEmpty() || ops.func_152683_b((Object)player.func_146103_bH()) != null) {
            return true;
        }
        UUID uuid = player.func_146103_bH().getId();
        if (!this.cards.containsKey(uuid)) {
            return false;
        }
        return this.cards.get(uuid).hasPermission(permission);
    }

    @Override
    public void rebuild() {
        this.cards.clear();
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            if (!(node instanceof ISecurityCardContainer) || !node.canUpdate()) continue;
            for (ISecurityCard card : ((ISecurityCardContainer)((Object)node)).getCards()) {
                this.cards.put(card.getOwner(), card);
            }
        }
    }
}

