/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.solderer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.solderer.SoldererRecipeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SoldererRecipeLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void load() {
        JsonContext context = new JsonContext("refinedstorage");
        CraftingHelper.findFiles((ModContainer)Loader.instance().activeModContainer(), (String)"assets/refinedstorage/solderer_recipes", root -> true, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation("refinedstorage", name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                API.instance().getSoldererRegistry().addRecipe(new SoldererRecipeFactory(key, (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class)).create(context));
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error while reading JSON solderer recipe {}", (Object)key, (Object)e);
                Boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read JSON solderer recipe {} from {}", (Object)key, file, (Object)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        });
    }
}

