/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageDiskItem
implements IStorageDisk<ItemStack> {
    private static final int PROTOCOL = 1;
    private static final String NBT_PROTOCOL = "Protocol";
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_STORED = "Stored";
    private static final String NBT_ITEM_TYPE = "Type";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_DAMAGE = "Damage";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";
    private NBTTagCompound tag;
    private int capacity;
    private Runnable listener = () -> {};
    private Supplier<Boolean> voidExcess;
    private Supplier<AccessType> accessType;
    private Multimap<Item, ItemStack> stacks = ArrayListMultimap.create();

    public StorageDiskItem(NBTTagCompound tag, int capacity) {
        this.tag = tag;
        this.capacity = capacity;
    }

    public NBTTagCompound getStorageTag() {
        return this.tag;
    }

    @Override
    public void readFromNBT() {
        NBTTagList list = (NBTTagList)this.tag.func_74781_a(NBT_ITEMS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(Item.func_150899_d((int)tag.func_74762_e(NBT_ITEM_TYPE)), tag.func_74762_e(NBT_ITEM_QUANTITY), tag.func_74762_e(NBT_ITEM_DAMAGE), tag.func_74764_b(NBT_ITEM_CAPS) ? tag.func_74775_l(NBT_ITEM_CAPS) : null);
            stack.func_77982_d(tag.func_74764_b(NBT_ITEM_NBT) ? tag.func_74775_l(NBT_ITEM_NBT) : null);
            if (stack.func_190926_b()) continue;
            this.stacks.put((Object)stack.func_77973_b(), (Object)stack);
        }
    }

    @Override
    public void writeToNBT() {
        NBTTagList list = new NBTTagList();
        NBTTagCompound dummy = new NBTTagCompound();
        for (ItemStack stack : this.stacks.values()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a(NBT_ITEM_TYPE, Item.func_150891_b((Item)stack.func_77973_b()));
            itemTag.func_74768_a(NBT_ITEM_QUANTITY, stack.func_190916_E());
            itemTag.func_74768_a(NBT_ITEM_DAMAGE, stack.func_77952_i());
            if (stack.func_77942_o()) {
                itemTag.func_74782_a(NBT_ITEM_NBT, (NBTBase)stack.func_77978_p());
            }
            stack.func_77955_b(dummy);
            if (dummy.func_74764_b("ForgeCaps")) {
                itemTag.func_74782_a(NBT_ITEM_CAPS, dummy.func_74781_a("ForgeCaps"));
            }
            dummy.func_82580_o("ForgeCaps");
            list.func_74742_a((NBTBase)itemTag);
        }
        this.tag.func_74782_a(NBT_ITEMS, (NBTBase)list);
        this.tag.func_74768_a(NBT_PROTOCOL, 1);
    }

    @Override
    public StorageDiskType getType() {
        return StorageDiskType.ITEMS;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public synchronized ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    if (this.voidExcess.get().booleanValue()) {
                        return null;
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                if (!simulate) {
                    this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                    otherStack.func_190917_f(remainingSpace);
                    this.listener.run();
                }
                return this.voidExcess.get() != false ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)(size - remainingSpace));
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
                otherStack.func_190917_f(size);
                this.listener.run();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                if (this.voidExcess.get().booleanValue()) {
                    return null;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            if (!simulate) {
                this.tag.func_74768_a(NBT_STORED, this.getStored() + remainingSpace);
                this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remainingSpace));
                this.listener.run();
            }
            return this.voidExcess.get() != false ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(size - remainingSpace));
        }
        if (!simulate) {
            this.tag.func_74768_a(NBT_STORED, this.getStored() + size);
            this.stacks.put((Object)stack.func_77973_b(), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            this.listener.run();
        }
        return null;
    }

    @Override
    @Nullable
    public synchronized ItemStack extract(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        ArrayList toAttempt = null;
        if ((flags & 8) == 8) {
            for (ItemStack ore : StackUtils.getEquivalentStacks(stack)) {
                if (toAttempt == null) {
                    toAttempt = new ArrayList(this.stacks.get((Object)ore.func_77973_b()));
                    continue;
                }
                toAttempt.addAll(this.stacks.get((Object)ore.func_77973_b()));
            }
        }
        if (toAttempt == null) {
            toAttempt = this.stacks.get((Object)stack.func_77973_b());
        }
        for (ItemStack otherStack : toAttempt) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.func_190916_E()) {
                size = otherStack.func_190916_E();
            }
            if (!simulate) {
                if (otherStack.func_190916_E() - size == 0) {
                    this.stacks.remove((Object)otherStack.func_77973_b(), (Object)otherStack);
                } else {
                    otherStack.func_190918_g(size);
                }
                this.tag.func_74768_a(NBT_STORED, this.getStored() - size);
                this.listener.run();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return StorageDiskItem.getStored(this.tag);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType.get();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_ITEMS) && stack.func_77978_p().func_74764_b(NBT_STORED);
    }

    @Override
    public void onPassContainerContext(Runnable listener, Supplier<Boolean> voidExcess, Supplier<AccessType> accessType) {
        this.listener = listener;
        this.voidExcess = voidExcess;
        this.accessType = accessType;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        int inserted;
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        int n = inserted = remainder == null ? size : size - remainder.func_190916_E();
        if (this.voidExcess.get().booleanValue() && storedPreInsertion + inserted > this.getCapacity()) {
            inserted = this.getCapacity() - storedPreInsertion;
        }
        return inserted;
    }

    public static NBTTagCompound getShareTag(@Nullable NBTTagCompound tag) {
        NBTTagCompound otherTag = new NBTTagCompound();
        otherTag.func_74768_a(NBT_STORED, StorageDiskItem.getStored(tag));
        otherTag.func_74782_a(NBT_ITEMS, (NBTBase)new NBTTagList());
        otherTag.func_74768_a(NBT_PROTOCOL, 1);
        return otherTag;
    }

    public static int getStored(@Nullable NBTTagCompound tag) {
        return tag == null ? 0 : tag.func_74762_e(NBT_STORED);
    }

    public static NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_ITEMS, (NBTBase)new NBTTagList());
        tag.func_74768_a(NBT_STORED, 0);
        tag.func_74768_a(NBT_PROTOCOL, 1);
        return tag;
    }
}

