/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class StorageDiskItemPortable
implements IStorageDisk<ItemStack> {
    private IStorageDisk<ItemStack> parent;
    private IPortableGrid portableGrid;

    public StorageDiskItemPortable(IStorageDisk<ItemStack> parent, IPortableGrid portableGrid) {
        this.parent = parent;
        this.portableGrid = portableGrid;
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return this.parent.isValid(stack);
    }

    @Override
    public void onPassContainerContext(Runnable listener, Supplier<Boolean> voidExcess, Supplier<AccessType> accessType) {
        this.parent.onPassContainerContext(listener, voidExcess, accessType);
    }

    @Override
    public void readFromNBT() {
        this.parent.readFromNBT();
    }

    @Override
    public void writeToNBT() {
        this.parent.writeToNBT();
    }

    @Override
    public StorageDiskType getType() {
        return this.parent.getType();
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, boolean simulate) {
        int inserted;
        int storedPre = this.parent.getStored();
        ItemStack remainder = this.parent.insert(stack, size, simulate);
        if (!simulate && (inserted = this.parent.getCacheDelta(storedPre, size, remainder)) > 0) {
            this.portableGrid.getCache().add(stack, inserted, false, false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        ItemStack extracted = this.parent.extract(stack, size, flags, simulate);
        if (!simulate && extracted != null) {
            this.portableGrid.getCache().remove(extracted, extracted.func_190916_E(), false);
        }
        return extracted;
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }
}

