/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListItemOredicted;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class StackListItem
implements IStackList<ItemStack> {
    private ArrayListMultimap<Item, ItemStack> stacks = ArrayListMultimap.create();
    private List<ItemStack> removeTracker = new LinkedList<ItemStack>();
    protected boolean needsCleanup = false;
    private Set<Item> touchedItems = new HashSet<Item>();

    @Override
    public void add(@Nonnull ItemStack stack, int size) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if ((long)otherStack.func_190916_E() + (long)size > Integer.MAX_VALUE) {
                otherStack.func_190920_e(Integer.MAX_VALUE);
            } else {
                otherStack.func_190917_f(size);
            }
            return;
        }
        this.stacks.put((Object)stack.func_77973_b(), (Object)(size == 0 ? stack.func_77946_l() : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size)));
    }

    @Override
    public boolean remove(@Nonnull ItemStack stack, int size) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            boolean success = otherStack.func_190916_E() - size >= 0;
            otherStack.func_190918_g(size);
            if (otherStack.func_190926_b()) {
                this.touchedItems.add(stack.func_77973_b());
                this.needsCleanup = true;
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean trackedRemove(@Nonnull ItemStack stack, int size) {
        for (ItemStack otherStack : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            ItemStack removed = ItemHandlerHelper.copyStackWithSize((ItemStack)otherStack, (int)Math.min(size, otherStack.func_190916_E()));
            this.removeTracker.add(removed);
            boolean success = otherStack.func_190916_E() - size >= 0;
            otherStack.func_190918_g(size);
            if (otherStack.func_190926_b()) {
                this.touchedItems.add(stack.func_77973_b());
                this.needsCleanup = true;
            }
            return success;
        }
        return false;
    }

    @Override
    public List<ItemStack> getRemoveTracker() {
        return this.removeTracker;
    }

    @Override
    public void undo() {
        this.removeTracker.forEach(s -> this.add((ItemStack)s, s.func_190916_E()));
        this.removeTracker.clear();
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        for (ItemStack otherStack : (flags & 8) == 8 ? this.stacks.values() : this.stacks.get((Object)stack.func_77973_b())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(int hash) {
        if (this.needsCleanup) {
            this.clean();
        }
        for (ItemStack stack : this.stacks.values()) {
            if (API.instance().getItemStackHashCode(stack) != hash) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void clear() {
        this.stacks.clear();
    }

    @Override
    public void clean() {
        List<Pair> toRemove = this.touchedItems.stream().flatMap(item -> this.stacks.get(item).stream().map(stack -> Pair.of((Object)item, (Object)stack))).filter(pair -> ((ItemStack)pair.getValue()).func_190926_b()).collect(Collectors.toList());
        toRemove.forEach(pair -> this.stacks.remove(pair.getLeft(), pair.getRight()));
        this.touchedItems.clear();
        this.needsCleanup = false;
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public int getSizeFromStack(ItemStack stack) {
        return stack.func_190916_E();
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getStacks() {
        if (this.needsCleanup) {
            this.clean();
        }
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> copy() {
        StackListItem list = new StackListItem();
        if (this.needsCleanup) {
            this.clean();
        }
        for (ItemStack stack : this.stacks.values()) {
            list.stacks.put((Object)stack.func_77973_b(), (Object)stack.func_77946_l());
        }
        return list;
    }

    @Nonnull
    public StackListItemOredicted getOredicted() {
        if (this.needsCleanup) {
            this.clean();
        }
        return new StackListItemOredicted(this);
    }

    public String toString() {
        return this.stacks.toString();
    }

    public static ItemStack[] toCraftingGrid(IStackList<ItemStack> list, List<ItemStack> grid, int compare) {
        ItemStack[] took = new ItemStack[Math.max(9, grid.size())];
        for (int i = 0; i < grid.size(); ++i) {
            ItemStack taken;
            ItemStack input = grid.get(i);
            if (input == null) continue;
            compare = input.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            ItemStack actualInput = list.get(input, compare);
            if (actualInput == null) continue;
            took[i] = taken = ItemHandlerHelper.copyStackWithSize((ItemStack)actualInput, (int)input.func_190916_E());
            list.remove(taken, taken.func_190916_E());
        }
        return took;
    }
}

