/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.block.BlockNode;
import com.raoulvdberge.refinedstorage.block.Direction;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.integration.mcmp.IntegrationMCMP;
import com.raoulvdberge.refinedstorage.integration.mcmp.RSMCMPAddon;
import com.raoulvdberge.refinedstorage.tile.TileCable;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCable
extends BlockNode {
    public static final AxisAlignedBB CORE_AABB = RenderUtils.getBounds(6, 6, 6, 10, 10, 10);
    private static final AxisAlignedBB NORTH_AABB = RenderUtils.getBounds(6, 6, 0, 10, 10, 6);
    private static final AxisAlignedBB EAST_AABB = RenderUtils.getBounds(10, 6, 6, 16, 10, 10);
    private static final AxisAlignedBB SOUTH_AABB = RenderUtils.getBounds(6, 6, 10, 10, 10, 16);
    private static final AxisAlignedBB WEST_AABB = RenderUtils.getBounds(0, 6, 6, 6, 10, 10);
    private static final AxisAlignedBB UP_AABB = RenderUtils.getBounds(6, 10, 6, 10, 16, 10);
    private static final AxisAlignedBB DOWN_AABB = RenderUtils.getBounds(6, 0, 6, 10, 6, 10);
    protected static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    protected static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    protected static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    protected static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    protected static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private IBlockState stateForRendering;

    public BlockCable(String name) {
        super(name);
    }

    public BlockCable() {
        this("cable");
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCable();
    }

    @Override
    public boolean hasConnectivityState() {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return super.createBlockStateBuilder().add(new IProperty[]{NORTH}).add(new IProperty[]{EAST}).add(new IProperty[]{SOUTH}).add(new IProperty[]{WEST}).add(new IProperty[]{UP}).add(new IProperty[]{DOWN}).build();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile(world, pos) : world.func_175625_s(pos);
        state = super.func_176221_a(state, world, pos).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.hasConnectionWith(world, pos, tile, EnumFacing.DOWN)));
        return state;
    }

    public IBlockState getActualStateForRendering(IBlockAccess world, BlockPos pos) {
        if (this.stateForRendering == null) {
            this.stateForRendering = this.func_180661_e().func_177621_b();
        }
        return this.func_176221_a(this.stateForRendering, world, pos);
    }

    private boolean hasConnectionWith(IBlockAccess world, BlockPos pos, TileEntity tile, EnumFacing direction) {
        if (!(tile instanceof TileNode)) {
            return false;
        }
        TileEntity otherTile = world.func_175625_s(pos.func_177972_a(direction));
        EnumFacing otherTileSide = direction.func_176734_d();
        if (otherTile != null && otherTile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, otherTileSide)) {
            if (this.getDirection() != null && ((NetworkNode)((TileNode)tile).getNode()).getFacingTile() == otherTile) {
                return false;
            }
            if (IntegrationMCMP.isLoaded()) {
                return RSMCMPAddon.hasConnectionWith(tile, Collections.singletonList(BlockCable.getCableExtensionAABB(direction))) && RSMCMPAddon.hasConnectionWith(otherTile, Collections.singletonList(BlockCable.getCableExtensionAABB(direction.func_176734_d())));
            }
            return true;
        }
        return false;
    }

    protected boolean hitCablePart(IBlockState state, World world, BlockPos pos, float hitX, float hitY, float hitZ) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        return RenderUtils.isInBounds(CORE_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)NORTH) != false && RenderUtils.isInBounds(NORTH_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)EAST) != false && RenderUtils.isInBounds(EAST_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)SOUTH) != false && RenderUtils.isInBounds(SOUTH_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)WEST) != false && RenderUtils.isInBounds(WEST_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)UP) != false && RenderUtils.isInBounds(UP_AABB, hitX, hitY, hitZ) || (Boolean)state.func_177229_b((IProperty)DOWN) != false && RenderUtils.isInBounds(DOWN_AABB, hitX, hitY, hitZ);
    }

    public List<AxisAlignedBB> getUnionizedCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(CORE_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            boxes.add(NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            boxes.add(EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            boxes.add(SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            boxes.add(WEST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            boxes.add(UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            boxes.add(DOWN_AABB);
        }
        return boxes;
    }

    public List<AxisAlignedBB> getNonUnionizedCollisionBoxes(IBlockState state) {
        return Collections.emptyList();
    }

    public List<AxisAlignedBB> getCollisionBoxes(IBlockState state) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.addAll(this.getUnionizedCollisionBoxes(state));
        boxes.addAll(this.getNonUnionizedCollisionBoxes(state));
        return boxes;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        for (AxisAlignedBB aabb : this.getCollisionBoxes(this.func_176221_a(state, (IBlockAccess)world, pos))) {
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        RenderUtils.AdvancedRayTraceResult result = RenderUtils.collisionRayTrace(pos, start, end, this.getCollisionBoxes(this.func_176221_a(state, (IBlockAccess)world, pos)));
        return result != null ? result.hit : null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, entity);
        if (this.getDirection() != null) {
            return state.func_177226_a((IProperty)this.getDirection().getProperty(), (Comparable)this.getDirection().getFrom(facing, pos, entity));
        }
        return state;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nullable
    public Direction getDirection() {
        return null;
    }

    public static AxisAlignedBB getCableExtensionAABB(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return NORTH_AABB;
        }
        if (facing == EnumFacing.EAST) {
            return EAST_AABB;
        }
        if (facing == EnumFacing.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == EnumFacing.WEST) {
            return WEST_AABB;
        }
        if (facing == EnumFacing.UP) {
            return UP_AABB;
        }
        if (facing == EnumFacing.DOWN) {
            return DOWN_AABB;
        }
        return NORTH_AABB;
    }
}

