/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeDetector;
import com.raoulvdberge.refinedstorage.block.BlockNode;
import com.raoulvdberge.refinedstorage.block.Direction;
import com.raoulvdberge.refinedstorage.tile.TileDetector;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDetector
extends BlockNode {
    private static final AxisAlignedBB AABB_DETECTOR = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockDetector() {
        super("detector");
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().add(new IProperty[]{POWERED}).build();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(((NetworkNodeDetector)((TileDetector)world.func_175625_s(pos)).getNode()).isPowered()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_DETECTOR;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDetector();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileDetector && ((NetworkNodeDetector)((TileDetector)tile).getNode()).isPowered() ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.tryOpenNetworkGui(5, player, world, pos, side);
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @Nullable
    public Direction getDirection() {
        return null;
    }
}

