/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.Scrollbar;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStart;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingPreview
extends GuiBase {
    private static final int VISIBLE_ROWS = 4;
    private List<ICraftingPreviewElement> stacks;
    private GuiScreen parent;
    private int hash;
    private int quantity;
    private GuiButton startButton;
    private GuiButton cancelButton;
    private IElementDrawers drawers = new CraftingPreviewElementDrawers();

    public GuiCraftingPreview(GuiScreen parent, List<ICraftingPreviewElement> stacks, int hash, int quantity) {
        super(new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }, 168, 171);
        this.stacks = new ArrayList<ICraftingPreviewElement>(stacks);
        this.parent = parent;
        this.hash = hash;
        this.quantity = quantity;
        this.scrollbar = new Scrollbar(149, 20, 12, 119);
    }

    @Override
    public void init(int x, int y) {
        this.cancelButton = this.addButton(x + 16, y + 144, 50, 20, GuiCraftingPreview.t("gui.cancel", new Object[0]));
        this.startButton = this.addButton(x + 85, y + 144, 50, 20, GuiCraftingPreview.t("misc.refinedstorage:start", new Object[0]));
        this.startButton.field_146124_l = this.stacks.stream().filter(ICraftingPreviewElement::hasMissing).count() == 0L;
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 4);
            this.scrollbar.setMaxOffset(this.getRows() - 4);
        }
        if (this.startButton != null && !this.startButton.field_146124_l && GuiCraftingPreview.func_146271_m() && GuiCraftingPreview.func_146272_n()) {
            this.startButton.field_146124_l = true;
        }
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_preview.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.stacks.isEmpty()) {
            GuiCraftingPreview.func_73734_a((int)(x + 7), (int)(y + 20), (int)(x + 142), (int)(y + 139), (int)-2368549);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        float scale;
        this.drawString(7, 7, GuiCraftingPreview.t("gui.refinedstorage:crafting_preview", new Object[0]));
        int x = 7;
        int y = 15;
        float f = scale = this.field_146289_q.func_82883_a() ? 1.0f : 0.5f;
        if (this.stacks.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            this.drawString(RenderUtils.getOffsetOnScale(x + 39, scale), RenderUtils.getOffsetOnScale(y + 57, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.circular", new Object[0]));
            this.drawString(RenderUtils.getOffsetOnScale(x + 40, scale), RenderUtils.getOffsetOnScale(y + 64, scale), GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.loop", new Object[0]));
            GlStateManager.func_179121_F();
        } else {
            int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 2 : 0;
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            ItemStack hoveringStack = null;
            FluidStack hoveringFluid = null;
            for (int i = 0; i < 8; ++i) {
                if (slot < this.stacks.size()) {
                    ICraftingPreviewElement stack = this.stacks.get(slot);
                    stack.draw(x, y + 5, this.drawers);
                    if (this.inBounds(x + 5, y + 7, 16, 16, mouseX, mouseY)) {
                        ItemStack itemStack = hoveringStack = stack.getId().equals("item_renderer") ? (ItemStack)stack.getElement() : null;
                        if (hoveringStack == null) {
                            FluidStack fluidStack = hoveringFluid = stack.getId().equals("fluid_renderer") ? (FluidStack)stack.getElement() : null;
                        }
                    }
                }
                if (i % 2 == 1) {
                    x -= 68;
                    y += 30;
                } else {
                    x += 68;
                }
                ++slot;
            }
            if (hoveringStack != null) {
                this.drawTooltip(hoveringStack, mouseX, mouseY, hoveringStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
            } else if (hoveringFluid != null) {
                this.drawTooltip(mouseX, mouseY, hoveringFluid.getLocalizedName());
            }
            if (!this.startButton.field_146124_l && this.inBounds(85, 144, 50, 20, mouseX, mouseY)) {
                this.drawTooltip(mouseX, mouseY, GuiCraftingPreview.t("gui.refinedstorage:crafting_preview.force_start", new Object[0]));
            }
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 28 && this.startButton.field_146124_l) {
            this.startRequest();
        } else if (keyCode == 1) {
            this.close();
        } else {
            super.func_73869_a(character, keyCode);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == this.startButton.field_146127_k) {
            this.startRequest();
        } else if (button.field_146127_k == this.cancelButton.field_146127_k) {
            this.close();
        }
    }

    private void startRequest() {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridCraftingStart(this.hash, this.quantity));
        this.close();
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.stacks.size() / 2.0f));
    }

    private void close() {
        FMLClientHandler.instance().showGuiScreen((Object)this.parent);
    }

    public class CraftingPreviewElementDrawers
    extends GuiBase.ElementDrawers {
        private IElementDrawer<Integer> overlayDrawer = (x, y, colour) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 67), (int)(y + 29), (int)colour);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }
    }
}

