/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.filtering;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterCraftable;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterFilter;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterMod;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterName;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterOreDict;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterTooltip;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public final class GridFilterParser {
    public static List<Predicate<IGridStack>> getFilters(IGrid grid, String query, List<IFilter> filters) {
        LinkedList<Predicate<IGridStack>> gridFilters = new LinkedList<Predicate<IGridStack>>();
        for (String part : query.toLowerCase().trim().split(" ")) {
            if (part.startsWith("@")) {
                gridFilters.add(new GridFilterMod(part.substring(1)));
                continue;
            }
            if (part.startsWith("#")) {
                gridFilters.add(new GridFilterTooltip(part.substring(1)));
                continue;
            }
            if (part.startsWith("$")) {
                gridFilters.add(new GridFilterOreDict(part.substring(1)));
                continue;
            }
            gridFilters.add(new GridFilterName(part));
        }
        if (grid.getViewType() == 1) {
            gridFilters.add(new GridFilterCraftable(false));
        } else if (grid.getViewType() == 2) {
            gridFilters.add(new GridFilterCraftable(true));
        }
        if (!filters.isEmpty()) {
            gridFilters.add(new GridFilterFilter(filters));
        }
        return gridFilters;
    }
}

