/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.GridTab;
import com.raoulvdberge.refinedstorage.apiimpl.util.Filter;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFilterItems;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ItemHandlerFilter
extends ItemHandlerBase {
    private List<IFilter> filters;
    private List<IGridTab> tabs;

    public ItemHandlerFilter(List<IFilter> filters, List<IGridTab> tabs, @Nullable Consumer<Integer> listener) {
        super(4, listener, new ItemValidatorBasic(RSItems.FILTER));
        this.filters = filters;
        this.tabs = tabs;
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.filters.clear();
        this.tabs.clear();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack filter = this.getStackInSlot(i);
            if (filter.func_190926_b()) continue;
            this.addFilter(filter);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuiGrid.markForSorting();
        }
    }

    private void addFilter(ItemStack filter) {
        int compare = ItemFilter.getCompare(filter);
        int mode = ItemFilter.getMode(filter);
        boolean modFilter = ItemFilter.isModFilter(filter);
        ItemHandlerFilterItems items = new ItemHandlerFilterItems(filter);
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        for (ItemStack stack : items.getFilteredItems()) {
            if (stack.func_77973_b() == RSItems.FILTER) {
                this.addFilter(stack);
                continue;
            }
            if (stack.func_190926_b()) continue;
            filters.add(new Filter(stack, compare, mode, modFilter));
        }
        ItemStack icon = ItemFilter.getIcon(filter);
        if (icon.func_190926_b()) {
            this.filters.addAll(filters);
        } else {
            this.tabs.add(new GridTab(filters, ItemFilter.getName(filter), icon));
        }
    }
}

