/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageDiskFluid;
import com.raoulvdberge.refinedstorage.block.FluidStorageType;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidStorageDisk
extends ItemBase
implements IStorageDiskProvider<FluidStack> {
    public static final int TYPE_64K = 0;
    public static final int TYPE_128K = 1;
    public static final int TYPE_256K = 2;
    public static final int TYPE_512K = 3;
    public static final int TYPE_CREATIVE = 4;
    public static final int TYPE_DEBUG = 5;

    public ItemFluidStorageDisk() {
        super("fluid_storage_disk");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            items.add((Object)API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, new ItemStack((Item)this, 1, i)));
        }
    }

    private void applyDebugDiskData(ItemStack stack) {
        NBTTagCompound debugDiskTag = API.instance().getDefaultStorageDiskBehavior().getTag(StorageDiskType.FLUIDS);
        StorageDiskFluid storage = new StorageDiskFluid(debugDiskTag, -1);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            storage.insert(new FluidStack(fluid, 0), 1000000, false);
        }
        storage.writeToNBT();
        stack.func_77982_d(debugDiskTag);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!stack.func_77942_o()) {
            if (stack.func_77960_j() == 5) {
                this.applyDebugDiskData(stack);
            } else {
                API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, stack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack disk = player.func_184586_b(hand);
        IStorageDisk<FluidStack> storage = this.create(disk);
        if (!world.field_72995_K && player.func_70093_af() && storage.isValid(disk) && storage.getStored() <= 0 && disk.func_77960_j() != 4) {
            ItemStack storagePart = new ItemStack((Item)RSItems.FLUID_STORAGE_PART, 1, disk.func_77960_j());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.STORAGE_HOUSING));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)disk);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        IStorageDisk<FluidStack> storage = this.create(stack);
        if (storage.isValid(stack)) {
            if (storage.getCapacity() == -1) {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{storage.getStored()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{storage.getStored(), storage.getCapacity()}));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        API.instance().getDefaultStorageDiskBehavior().initDisk(StorageDiskType.FLUIDS, stack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return API.instance().getDefaultStorageDiskBehavior().getShareTag(StorageDiskType.FLUIDS, stack);
    }

    @Override
    @Nonnull
    public IStorageDisk<FluidStack> create(ItemStack disk) {
        return API.instance().getDefaultStorageDiskBehavior().createFluidStorage(disk.func_77978_p(), FluidStorageType.getById(disk.func_77952_i()).getCapacity());
    }
}

