/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemPattern
extends ItemBase
implements ICraftingPatternProvider {
    private static Map<ItemStack, CraftingPattern> PATTERN_CACHE = new HashMap<ItemStack, CraftingPattern>();
    private static final String NBT_SLOT = "Slot_%d";
    private static final String NBT_OUTPUTS = "Outputs";
    private static final String NBT_OREDICT = "Oredict";
    private static final String NBT_BLOCKING = "Blocking";

    public ItemPattern() {
        super("pattern");
    }

    public static CraftingPattern getPatternFromCache(World world, ItemStack stack) {
        if (!PATTERN_CACHE.containsKey(stack)) {
            PATTERN_CACHE.put(stack, new CraftingPattern(world, null, stack));
        }
        return PATTERN_CACHE.get(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!stack.func_77942_o()) {
            return;
        }
        CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
        if (pattern.isValid()) {
            if (GuiScreen.func_146272_n() || ItemPattern.isProcessing(stack)) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.inputs", (Object[])new Object[0]) + TextFormatting.RESET);
                ItemPattern.combineItems(tooltip, true, StackUtils.toNonNullList(pattern.getInputs()));
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.outputs", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            ItemPattern.combineItems(tooltip, true, StackUtils.toNonNullList(pattern.getOutputs()));
            if (ItemPattern.isOredict(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"misc.refinedstorage:pattern.oredict", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            if (ItemPattern.isBlocking(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"misc.refinedstorage:blocking", (Object[])new Object[0]) + TextFormatting.RESET);
            }
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"misc.refinedstorage:pattern.invalid", (Object[])new Object[0]) + TextFormatting.RESET);
        }
    }

    public static void setSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_SLOT, slot), (NBTBase)stack.serializeNBT());
    }

    public static ItemStack getSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return null;
        }
        return new ItemStack(pattern.func_77978_p().func_74775_l(id));
    }

    public static void addOutput(ItemStack pattern, ItemStack output) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        NBTTagList outputs = !pattern.func_77978_p().func_74764_b(NBT_OUTPUTS) ? new NBTTagList() : pattern.func_77978_p().func_150295_c(NBT_OUTPUTS, 10);
        outputs.func_74742_a((NBTBase)output.serializeNBT());
        pattern.func_77978_p().func_74782_a(NBT_OUTPUTS, (NBTBase)outputs);
    }

    public static List<ItemStack> getOutputs(ItemStack pattern) {
        if (!ItemPattern.isProcessing(pattern)) {
            return null;
        }
        IStackList<ItemStack> outputs = API.instance().createItemStackList();
        NBTTagList outputsTag = pattern.func_77978_p().func_150295_c(NBT_OUTPUTS, 10);
        for (int i = 0; i < outputsTag.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(outputsTag.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            outputs.add(stack);
        }
        return new ArrayList<ItemStack>(outputs.getStacks());
    }

    public static boolean isProcessing(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_OUTPUTS);
    }

    public static boolean isOredict(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_OREDICT) && pattern.func_77978_p().func_74767_n(NBT_OREDICT);
    }

    public static boolean isBlocking(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_BLOCKING) && pattern.func_77978_p().func_74767_n(NBT_BLOCKING);
    }

    public static void setOredict(ItemStack pattern, boolean oredict) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_OREDICT, oredict);
    }

    public static void setBlocking(ItemStack pattern, boolean blockingTask) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_BLOCKING, blockingTask);
    }

    public static void combineItems(List<String> tooltip, boolean displayAmount, NonNullList<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (((ItemStack)stacks.get(i)).func_190926_b() || combinedIndices.contains(i)) continue;
            ItemStack stack = (ItemStack)stacks.get(i);
            String data = stack.func_82833_r();
            int amount = stack.func_190916_E();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, (ItemStack)stacks.get(j))) continue;
                amount += ((ItemStack)stacks.get(j)).func_190916_E();
                combinedIndices.add(j);
            }
            data = (displayAmount ? TextFormatting.WHITE + String.valueOf(amount) + " " : "") + TextFormatting.GRAY + data;
            tooltip.add(data);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.PATTERN, player.func_184586_b(hand).func_190916_E()));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    @Nonnull
    public ICraftingPattern create(World world, ItemStack stack, ICraftingPatternContainer container) {
        return new CraftingPattern(world, container, stack);
    }
}

