/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridFluidUpdate
implements IMessage,
IMessageHandler<MessageGridFluidUpdate, IMessage> {
    private INetwork network;
    private boolean canCraft;
    private List<GridStackFluid> stacks = new ArrayList<GridStackFluid>();

    public MessageGridFluidUpdate() {
    }

    public MessageGridFluidUpdate(INetwork network, boolean canCraft) {
        this.network = network;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(new GridStackFluid(StackUtils.readFluidStack(buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        buf.writeInt(this.network.getFluidStorageCache().getList().getStacks().size());
        for (FluidStack stack : this.network.getFluidStorageCache().getList().getStacks()) {
            StackUtils.writeFluidStack(buf, stack);
        }
    }

    public IMessage onMessage(MessageGridFluidUpdate message, MessageContext ctx) {
        GuiGrid.CAN_CRAFT = message.canCraft;
        GuiGrid.FLUIDS.clear();
        for (GridStackFluid item : message.stacks) {
            GuiGrid.FLUIDS.put((Object)item.getStack().getFluid(), (Object)item);
        }
        GuiGrid.markForSorting();
        return null;
    }
}

