/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGridItemUpdate
implements IMessage,
IMessageHandler<MessageGridItemUpdate, IMessage> {
    private Consumer<ByteBuf> sendHandler;
    private boolean canCraft;
    private List<GridStackItem> stacks = new ArrayList<GridStackItem>();

    public MessageGridItemUpdate() {
    }

    public MessageGridItemUpdate(INetwork network, boolean canCraft) {
        this.sendHandler = buf -> {
            int size = network.getItemStorageCache().getList().getStacks().size();
            for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
                size = (int)((long)size + pattern.getOutputs().stream().filter(Objects::nonNull).count());
            }
            buf.writeInt(size);
            for (ItemStack stack : network.getItemStorageCache().getList().getStacks()) {
                StackUtils.writeItemStack(buf, stack, network, false);
            }
            for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
                for (ItemStack output : pattern.getOutputs()) {
                    if (output == null) continue;
                    StackUtils.writeItemStack(buf, output, network, true);
                }
            }
        };
        this.canCraft = canCraft;
    }

    public MessageGridItemUpdate(Consumer<ByteBuf> sendHandler, boolean canCraft) {
        this.sendHandler = sendHandler;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add(new GridStackItem(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        this.sendHandler.accept(buf);
    }

    public IMessage onMessage(MessageGridItemUpdate message, MessageContext ctx) {
        GuiGrid.CAN_CRAFT = message.canCraft;
        GuiGrid.ITEMS.clear();
        for (GridStackItem item : message.stacks) {
            boolean canAdd = true;
            if (item.doesDisplayCraftText()) {
                for (GridStackItem otherItem : GuiGrid.ITEMS.get((Object)item.getStack().func_77973_b())) {
                    if (!API.instance().getComparer().isEqualNoQuantity(item.getStack(), otherItem.getStack())) continue;
                    canAdd = false;
                    break;
                }
            }
            if (!canAdd) continue;
            GuiGrid.ITEMS.put((Object)item.getStack().func_77973_b(), (Object)item);
        }
        GuiGrid.markForSorting();
        return null;
    }
}

