/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.block.BlockDiskDrive;
import com.raoulvdberge.refinedstorage.render.BakedModelTRSR;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedModelDiskDrive
implements IBakedModel {
    private IBakedModel base;
    private Map<EnumFacing, IBakedModel> models = new HashMap<EnumFacing, IBakedModel>();
    private Map<EnumFacing, Map<Integer, List<IBakedModel>>> disks = new HashMap<EnumFacing, Map<Integer, List<IBakedModel>>>();
    private LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) throws Exception {
            EnumFacing facing = (EnumFacing)key.state.func_177229_b((IProperty)RSBlocks.DISK_DRIVE.getDirection().getProperty());
            List quads = ((IBakedModel)BakedModelDiskDrive.this.models.get(facing)).func_188616_a(key.state, key.side, 0L);
            for (int i = 0; i < 8; ++i) {
                if (key.diskState[i] == 4) continue;
                quads.addAll(((IBakedModel)((List)((Map)BakedModelDiskDrive.this.disks.get(facing)).get(key.diskState[i])).get(i)).func_188616_a(key.state, key.side, 0L));
            }
            return quads;
        }
    });

    public BakedModelDiskDrive(IBakedModel base, IBakedModel disk, IBakedModel diskNearCapacity, IBakedModel diskFull, IBakedModel diskDisconnected) {
        this.base = base;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            this.models.put(facing, new BakedModelTRSR(base, facing));
            this.disks.put(facing, new HashMap());
            this.disks.get(facing).put(0, new ArrayList());
            this.disks.get(facing).put(1, new ArrayList());
            this.disks.get(facing).put(2, new ArrayList());
            this.disks.get(facing).put(3, new ArrayList());
            this.initDiskModels(disk, 0, facing);
            this.initDiskModels(diskNearCapacity, 1, facing);
            this.initDiskModels(diskFull, 2, facing);
            this.initDiskModels(diskDisconnected, 3, facing);
        }
    }

    private void initDiskModels(IBakedModel disk, int type, EnumFacing facing) {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                BakedModelTRSR model = new BakedModelTRSR(disk, facing);
                Vector3f trans = model.transformation.getTranslation();
                if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                    trans.x = trans.x + (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == EnumFacing.NORTH ? -1 : 1);
                } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                    trans.z = trans.z + (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == EnumFacing.EAST ? -1 : 1);
                }
                trans.y -= 0.125f + (float)y * 3.0f / 16.0f;
                model.transformation = new TRSRTransformation(trans, model.transformation.getLeftRot(), model.transformation.getScale(), model.transformation.getRightRot());
                this.disks.get(facing).get(type).add(model);
            }
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (!(state instanceof IExtendedBlockState)) {
            return this.base.func_188616_a(state, side, rand);
        }
        Integer[] diskState = (Integer[])((IExtendedBlockState)state).getValue(BlockDiskDrive.DISK_STATE);
        if (diskState == null) {
            return this.base.func_188616_a(state, side, rand);
        }
        CacheKey key = new CacheKey(((IExtendedBlockState)state).getClean(), side, diskState);
        return (List)this.cache.getUnchecked((Object)key);
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.base.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.base.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.base.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.base.func_188617_f();
    }

    private class CacheKey {
        private IBlockState state;
        private EnumFacing side;
        private Integer[] diskState;

        CacheKey(@Nullable IBlockState state, EnumFacing side, Integer[] diskState) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals(cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

