/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeDetector;
import com.raoulvdberge.refinedstorage.gui.GuiDetector;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileDetector
extends TileNode<NetworkNodeDetector> {
    private static final String NBT_POWERED = "Powered";
    public static final TileDataParameter<Integer, TileDetector> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, TileDetector> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer, TileDetector> MODE = new TileDataParameter<Integer, TileDetector>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeDetector)t.getNode()).getMode(), (t, v) -> {
        if (v == 0 || v == 1 || v == 2 || v == 3) {
            ((NetworkNodeDetector)t.getNode()).setMode((int)v);
            ((NetworkNodeDetector)t.getNode()).markDirty();
        }
    });
    public static final TileDataParameter<Integer, TileDetector> AMOUNT = new TileDataParameter<Integer, TileDetector>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeDetector)t.getNode()).getAmount(), (t, v) -> {
        ((NetworkNodeDetector)t.getNode()).setAmount((int)v);
        ((NetworkNodeDetector)t.getNode()).markDirty();
    }, p -> {
        GuiScreen gui;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (gui = Minecraft.func_71410_x().field_71462_r) instanceof GuiDetector) {
            GuiDetector.AMOUNT.func_146180_a(String.valueOf(p));
        }
    });

    public TileDetector() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(AMOUNT);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        ((NetworkNodeDetector)this.getNode()).setPowered(tag.func_74767_n(NBT_POWERED));
        super.readUpdate(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_POWERED, ((NetworkNodeDetector)this.getNode()).isPowered());
        return tag;
    }

    @Override
    @Nonnull
    public NetworkNodeDetector createNode(World world, BlockPos pos) {
        return new NetworkNodeDetector(world, pos);
    }

    @Override
    public String getNodeId() {
        return "detector";
    }
}

