/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.util.IWrenchable;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public abstract class TileNode<N extends NetworkNode>
extends TileBase
implements INetworkNodeProxy<N>,
IRedstoneConfigurable,
IWrenchable {
    public static final TileDataParameter<Integer, TileNode> REDSTONE_MODE = RedstoneMode.createParameter();
    protected static final String NBT_ACTIVE = "Active";
    private N clientNode;

    public TileNode() {
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((NetworkNode)this.getNode()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((NetworkNode)this.getNode()).setRedstoneMode(mode);
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        return ((NetworkNode)this.getNode()).writeConfiguration(tag);
    }

    @Override
    public void setDirection(EnumFacing direction) {
        super.setDirection(direction);
        ((NetworkNode)this.getNode()).resetDirection();
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        ((NetworkNode)this.getNode()).readConfiguration(tag);
        ((NetworkNode)this.getNode()).markDirty();
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_ACTIVE, ((NetworkNode)this.getNode()).getNetwork() != null && ((NetworkNode)this.getNode()).canUpdate());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        ((NetworkNode)this.getNode()).setActive(tag.func_74767_n(NBT_ACTIVE));
    }

    @Override
    @Nullable
    public IItemHandler getDrops() {
        return ((NetworkNode)this.getNode()).getDrops();
    }

    @Override
    @Nonnull
    public N getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.clientNode == null) {
                this.clientNode = this.createNode(this.field_145850_b, this.field_174879_c);
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(this.field_145850_b);
        NetworkNode node = (NetworkNode)manager.getNode(this.field_174879_c);
        if (node == null || !node.getId().equals(this.getNodeId())) {
            node = this.createNode(this.field_145850_b, this.field_174879_c);
            manager.setNode(this.field_174879_c, node);
            manager.markForSaving();
        }
        return (N)node;
    }

    public abstract N createNode(World var1, BlockPos var2);

    public abstract String getNodeId();

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }
}

