/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.item.ItemWirelessFluidGrid;
import com.raoulvdberge.refinedstorage.network.MessageWirelessFluidGridSettingsUpdate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessFluidGrid
implements IGrid {
    public static int ID;
    private ItemStack stack;
    private int networkDimension;
    private BlockPos network;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int size;

    public WirelessFluidGrid(int networkDimension, ItemStack stack) {
        this.networkDimension = networkDimension;
        this.network = new BlockPos(ItemWirelessFluidGrid.getX(stack), ItemWirelessFluidGrid.getY(stack), ItemWirelessFluidGrid.getZ(stack));
        this.stack = stack;
        this.sortingType = ItemWirelessFluidGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessFluidGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessFluidGrid.getSearchBoxMode(stack);
        this.size = ItemWirelessFluidGrid.getSize(stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public GridType getType() {
        return GridType.FLUID;
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        WorldServer world = DimensionManager.getWorld((int)this.networkDimension);
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.network);
            return tile instanceof INetwork ? (INetwork)tile : null;
        }
        return null;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:fluid_grid";
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return 0;
    }

    @Override
    public int getTabPage() {
        return 0;
    }

    @Override
    public int getTotalTabPages() {
        return 0;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), type, this.getSearchBoxMode(), this.getSize()));
        this.sortingType = type;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(direction, this.getSortingType(), this.getSearchBoxMode(), this.getSize()));
        this.sortingDirection = direction;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), searchBoxMode, this.getSize()));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public void onSizeChanged(int size) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessFluidGridSettingsUpdate(this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode(), size));
        this.size = size;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    @Override
    public void onTabSelectionChanged(int tab) {
    }

    @Override
    public void onTabPageChanged(int page) {
    }

    @Override
    public List<IFilter> getFilters() {
        return Collections.emptyList();
    }

    @Override
    public List<IGridTab> getTabs() {
        return Collections.emptyList();
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return null;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().onClose(player);
        }
    }
}

