/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid.portable;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.StorageDiskType;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageDiskItemPortable;
import com.raoulvdberge.refinedstorage.block.BlockPortableGrid;
import com.raoulvdberge.refinedstorage.block.PortableGridDiskState;
import com.raoulvdberge.refinedstorage.block.PortableGridType;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.integration.forgeenergy.EnergyForge;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerTile;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerStorage;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TilePortableGrid
extends TileBase
implements IGrid,
IPortableGrid,
IRedstoneConfigurable {
    public static final TileDataParameter<Integer, TilePortableGrid> REDSTONE_MODE = RedstoneMode.createParameter();
    public static final TileDataParameter<Integer, TilePortableGrid> ENERGY_STORED = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, t -> t.energyStorage.getEnergyStored());
    public static final TileDataParameter<Integer, TilePortableGrid> SORTING_DIRECTION = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSortingDirection, (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            t.setSortingDirection((int)v);
            t.func_70296_d();
        }
    }, p -> GuiGrid.markForSorting());
    public static final TileDataParameter<Integer, TilePortableGrid> SORTING_TYPE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSortingType, (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            t.setSortingType((int)v);
            t.func_70296_d();
        }
    }, p -> GuiGrid.markForSorting());
    public static final TileDataParameter<Integer, TilePortableGrid> SEARCH_BOX_MODE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSearchBoxMode, (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            t.setSearchBoxMode((int)v);
            t.func_70296_d();
        }
    }, p -> {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiGrid) {
            ((GuiGrid)Minecraft.func_71410_x().field_71462_r).updateSearchFieldFocus((int)p);
        }
    });
    public static final TileDataParameter<Integer, TilePortableGrid> SIZE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSize, (t, v) -> {
        if (IGrid.isValidSize(v)) {
            t.setSize((int)v);
            t.func_70296_d();
        }
    }, p -> {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    });
    public static final TileDataParameter<Integer, TilePortableGrid> TAB_SELECTED = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getTabSelected, (t, v) -> {
        t.setTabSelected(v.intValue() == t.getTabSelected() ? -1 : v);
        t.func_70296_d();
    }, p -> {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiGrid) {
            GuiGrid.markForSorting();
        }
    });
    public static final TileDataParameter<Integer, TilePortableGrid> TAB_PAGE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getTabPage, (t, v) -> {
        if (v >= 0 && v <= t.getTotalTabPages()) {
            t.setTabPage((int)v);
            t.func_70296_d();
        }
    });
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_DISK_STATE = "DiskState";
    private static final String NBT_CONNECTED = "Connected";
    private EnergyForge energyStorage = new EnergyForge(3200);
    private PortableGridType type;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, new ItemHandlerListenerTile(this));
    private ItemHandlerBase disk = new ItemHandlerBase(1, new ItemHandlerListenerTile(this), new Predicate[]{s -> NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK.test((ItemStack)s) && ((IStorageDiskProvider)s.func_77973_b()).create((ItemStack)s).getType() == StorageDiskType.ITEMS}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                if (TilePortableGrid.this.itemHandler != null) {
                    TilePortableGrid.this.cache.removeListener(TilePortableGrid.this.itemHandler);
                }
                if (this.getStackInSlot(slot).func_190926_b()) {
                    TilePortableGrid.this.storage = null;
                } else {
                    IStorageDiskProvider provider = (IStorageDiskProvider)this.getStackInSlot(slot).func_77973_b();
                    TilePortableGrid.this.storage = new StorageDiskItemPortable(provider.create(this.getStackInSlot(slot)), TilePortableGrid.this);
                    TilePortableGrid.this.storage.readFromNBT();
                    TilePortableGrid.this.storage.onPassContainerContext(() -> {
                        TilePortableGrid.this.func_70296_d();
                        TilePortableGrid.this.checkIfDiskStateChanged();
                    }, () -> false, () -> AccessType.INSERT_EXTRACT);
                }
                TilePortableGrid.this.cache.invalidate();
                if (TilePortableGrid.this.storage == null) {
                    TilePortableGrid.this.itemHandler = null;
                } else {
                    TilePortableGrid.this.itemHandler = new ItemHandlerStorage(TilePortableGrid.this.storage, TilePortableGrid.this.cache);
                    TilePortableGrid.this.cache.addListener(TilePortableGrid.this.itemHandler);
                }
                if (TilePortableGrid.this.field_145850_b != null) {
                    TilePortableGrid.this.checkIfDiskStateChanged();
                }
            }
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TilePortableGrid.this.storage != null) {
                TilePortableGrid.this.storage.writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    @Nullable
    private IStorageDisk<ItemStack> storage;
    private StorageCacheItemPortable cache = new StorageCacheItemPortable(this);
    private ItemGridHandlerPortable handler = new ItemGridHandlerPortable(this, this);
    private ItemHandlerStorage itemHandler = null;
    private PortableGridDiskState diskState = PortableGridDiskState.NONE;
    private boolean connected;

    public TilePortableGrid() {
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
    }

    public PortableGridDiskState getDiskState() {
        return this.diskState;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public PortableGridType getPortableType() {
        if (this.type == null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == RSBlocks.PORTABLE_GRID) {
            this.type = (PortableGridType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPortableGrid.TYPE));
        }
        return this.type == null ? PortableGridType.NORMAL : this.type;
    }

    public void onPassItemContext(ItemStack stack) {
        this.sortingType = ItemWirelessGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
        this.tabSelected = ItemWirelessGrid.getTabSelected(stack);
        this.tabPage = ItemWirelessGrid.getTabPage(stack);
        this.size = ItemWirelessGrid.getSize(stack);
        this.energyStorage.setEnergyStored(((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored());
        if (stack.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                StackUtils.readItems((IItemHandlerModifiable)this.filter, i, stack.func_77978_p());
            }
            StackUtils.readItems((IItemHandlerModifiable)this.disk, 4, stack.func_77978_p());
            this.redstoneMode = RedstoneMode.read(stack.func_77978_p());
        }
        this.diskState = TilePortableGrid.getDiskState(this);
        this.func_70296_d();
    }

    public ItemStack getAsItem() {
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
        ItemStack stack = new ItemStack((Block)RSBlocks.PORTABLE_GRID, 1, this.getPortableType() == PortableGridType.NORMAL ? 0 : 1);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("SortingDirection", this.sortingDirection);
        stack.func_77978_p().func_74768_a("SortingType", this.sortingType);
        stack.func_77978_p().func_74768_a("SearchBoxMode", this.searchBoxMode);
        stack.func_77978_p().func_74768_a("Size", this.size);
        stack.func_77978_p().func_74768_a("TabSelected", this.tabSelected);
        stack.func_77978_p().func_74768_a("TabPage", this.tabPage);
        ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(this.energyStorage.getEnergyStored(), false);
        for (int i = 0; i < 4; ++i) {
            StackUtils.writeItems((IItemHandler)this.filter, i, stack.func_77978_p());
        }
        StackUtils.writeItems((IItemHandler)this.disk, 4, stack.func_77978_p());
        this.redstoneMode.write(stack.func_77978_p());
        return stack;
    }

    @Override
    public GridType getType() {
        return GridType.NORMAL;
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        return null;
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.handler;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:portable_grid";
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.field_145850_b.field_72995_K ? SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.field_145850_b.field_72995_K ? SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.field_145850_b.field_72995_K ? SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.field_145850_b.field_72995_K ? TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.field_145850_b.field_72995_K ? TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 6.0f);
    }

    @Override
    public int getSize() {
        return this.field_145850_b.field_72995_K ? SIZE.getValue() : this.size;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(TAB_PAGE, page);
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public boolean isActive() {
        int stored;
        int n = stored = !this.field_145850_b.field_72995_K ? this.energyStorage.getEnergyStored() : ENERGY_STORED.getValue().intValue();
        if (this.getPortableType() != PortableGridType.CREATIVE && RS.INSTANCE.config.portableGridUsesEnergy && stored <= RS.INSTANCE.config.portableGridOpenUsage) {
            return false;
        }
        RedstoneMode redstoneMode = !this.field_145850_b.field_72995_K ? this.redstoneMode : RedstoneMode.getById(REDSTONE_MODE.getValue());
        return redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public IStorageCache<ItemStack> getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk<ItemStack> getStorage() {
        return this.storage;
    }

    @Override
    public List<EntityPlayer> getWatchers() {
        return this.dataManager.getPlayersWatching();
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.getPortableType() != PortableGridType.CREATIVE && this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c)) {
            this.energyStorage.extractEnergyInternal(energy);
            this.checkIfDiskStateChanged();
        }
        this.checkIfConnectivityChanged();
    }

    @Override
    public int getEnergy() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.getPortableType() != PortableGridType.CREATIVE) {
            return this.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    private void checkIfDiskStateChanged() {
        PortableGridDiskState newDiskState = TilePortableGrid.getDiskState(this);
        if (this.diskState != newDiskState) {
            this.diskState = newDiskState;
            WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    private void checkIfConnectivityChanged() {
        boolean isConnected;
        boolean bl = isConnected = this.getEnergy() != 0;
        if (this.connected != isConnected) {
            this.connected = isConnected;
            WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public ItemHandlerBase getDisk() {
        return this.disk;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
        tag.func_74768_a("SortingDirection", this.sortingDirection);
        tag.func_74768_a("SortingType", this.sortingType);
        tag.func_74768_a("SearchBoxMode", this.searchBoxMode);
        tag.func_74768_a("Size", this.size);
        tag.func_74768_a("TabSelected", this.tabSelected);
        tag.func_74768_a("TabPage", this.tabPage);
        StackUtils.writeItems((IItemHandler)this.disk, 0, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 1, tag);
        tag.func_74768_a(NBT_ENERGY, this.energyStorage.getEnergyStored());
        this.redstoneMode.write(tag);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b("SortingDirection")) {
            this.sortingDirection = tag.func_74762_e("SortingDirection");
        }
        if (tag.func_74764_b("SortingType")) {
            this.sortingType = tag.func_74762_e("SortingType");
        }
        if (tag.func_74764_b("SearchBoxMode")) {
            this.searchBoxMode = tag.func_74762_e("SearchBoxMode");
        }
        if (tag.func_74764_b("Size")) {
            this.size = tag.func_74762_e("Size");
        }
        if (tag.func_74764_b("TabSelected")) {
            this.tabSelected = tag.func_74762_e("TabSelected");
        }
        if (tag.func_74764_b("TabPage")) {
            this.tabPage = tag.func_74762_e("TabPage");
        }
        StackUtils.readItems((IItemHandlerModifiable)this.disk, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filter, 1, tag);
        if (tag.func_74764_b(NBT_ENERGY)) {
            this.energyStorage.setEnergyStored(tag.func_74762_e(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
    }

    public void onLoad() {
        super.onLoad();
        this.connected = this.getEnergy() != 0;
        this.diskState = TilePortableGrid.getDiskState(this);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        tag.func_74768_a(NBT_DISK_STATE, this.diskState.getId());
        tag.func_74757_a(NBT_CONNECTED, this.getEnergy() != 0);
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        this.diskState = PortableGridDiskState.getById(tag.func_74762_e(NBT_DISK_STATE));
        this.connected = tag.func_74767_n(NBT_CONNECTED);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || this.itemHandler != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        if (this.itemHandler != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onOpened(EntityPlayerMP player) {
        this.cache.sendUpdateTo((EntityPlayer)player);
        this.drainEnergy(RS.INSTANCE.config.portableGridOpenUsage);
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    public static PortableGridDiskState getDiskState(IPortableGrid portableGrid) {
        int capacity;
        if (portableGrid.getStorage() == null) {
            return PortableGridDiskState.NONE;
        }
        if (portableGrid.getEnergy() == 0) {
            return PortableGridDiskState.DISCONNECTED;
        }
        int stored = portableGrid.getStorage().getStored();
        if (stored == (capacity = portableGrid.getStorage().getCapacity())) {
            return PortableGridDiskState.FULL;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) >= 85) {
            return PortableGridDiskState.NEAR_CAPACITY;
        }
        return PortableGridDiskState.NORMAL;
    }
}

