/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.google.common.collect.ImmutableMap;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class RenderUtils {
    public static final DecimalFormat QUANTITY_FORMATTER = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat QUANTITY_FORMATTER_UNFORMATTED = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US));
    public static final Matrix4f EMPTY_MATRIX_TRANSFORM = RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).getMatrix();
    private static final TRSRTransformation FLIP_X = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_ITEM_TRANSFORM;
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_BLOCK_TRANSFORM;

    public static String formatQuantity(int qty) {
        if (qty >= 1000000) {
            float qtyShort = (float)qty / 1000000.0f;
            if (qty >= 100000000) {
                qtyShort = Math.round(qtyShort);
            }
            return QUANTITY_FORMATTER.format(qtyShort) + "M";
        }
        if (qty >= 1000) {
            float qtyShort = (float)qty / 1000.0f;
            if (qty >= 100000) {
                qtyShort = Math.round(qtyShort);
            }
            return QUANTITY_FORMATTER.format(qtyShort) + "K";
        }
        return String.valueOf(qty);
    }

    public static AxisAlignedBB getBounds(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return new AxisAlignedBB((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    public static boolean isInBounds(AxisAlignedBB aabb, float hitX, float hitY, float hitZ) {
        return (double)hitX >= aabb.field_72340_a && (double)hitX <= aabb.field_72336_d && (double)hitY >= aabb.field_72338_b && (double)hitY <= aabb.field_72337_e && (double)hitZ >= aabb.field_72339_c && (double)hitZ <= aabb.field_72334_f;
    }

    public static Vec3d getStart(EntityPlayer player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityPlayer player) {
        double reachDistance = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : (player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
        Vec3d lookVec = player.func_70040_Z();
        Vec3d start = RenderUtils.getStart(player);
        return start.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, Collection<AxisAlignedBB> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (AxisAlignedBB aabb : boxes) {
            double d;
            AdvancedRayTraceResult result;
            AdvancedRayTraceResult advancedRayTraceResult = result = aabb == null ? null : RenderUtils.collisionRayTrace(pos, start, end, aabb, i, null);
            if (result != null && (d = result.squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = result;
            }
            ++i;
        }
        return hit;
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB bounds, int subHit, Object hitInfo) {
        RayTraceResult result = bounds.func_186670_a(pos).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new RayTraceResult(RayTraceResult.Type.BLOCK, result.field_72307_f, result.field_178784_b, pos);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return new AdvancedRayTraceResult(result, bounds);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    private static TRSRTransformation leftifyTransform(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)FLIP_X.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(FLIP_X));
    }

    private static TRSRTransformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getDefaultItemTransforms() {
        if (DEFAULT_ITEM_TRANSFORM != null) {
            return DEFAULT_ITEM_TRANSFORM;
        }
        DEFAULT_ITEM_TRANSFORM = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)RenderUtils.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)RenderUtils.getTransform(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f)).build();
        return DEFAULT_ITEM_TRANSFORM;
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getDefaultBlockTransforms() {
        if (DEFAULT_BLOCK_TRANSFORM != null) {
            return DEFAULT_BLOCK_TRANSFORM;
        }
        TRSRTransformation thirdperson = RenderUtils.getTransform(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        DEFAULT_BLOCK_TRANSFORM = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)RenderUtils.getTransform(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RenderUtils.leftifyTransform(thirdperson)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RenderUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).build();
        return DEFAULT_BLOCK_TRANSFORM;
    }

    public static int getOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }

    static {
        QUANTITY_FORMATTER.setRoundingMode(RoundingMode.DOWN);
    }

    public static class FluidRenderer {
        private static final int TEX_WIDTH = 16;
        private static final int TEX_HEIGHT = 16;
        private static final int MIN_FLUID_HEIGHT = 1;
        private final int capacityMb;
        private final int width;
        private final int height;

        public FluidRenderer(int capacityMb, int width, int height) {
            this.capacityMb = capacityMb;
            this.width = width;
            this.height = height;
        }

        public void draw(Minecraft minecraft, int xPosition, int yPosition, FluidStack fluidStack) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            this.drawFluid(minecraft, xPosition, yPosition, fluidStack);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }

        private void drawFluid(Minecraft minecraft, int xPosition, int yPosition, FluidStack fluidStack) {
            if (fluidStack == null) {
                return;
            }
            Fluid fluid = fluidStack.getFluid();
            if (fluid == null) {
                return;
            }
            TextureMap textureMapBlocks = minecraft.func_147117_R();
            ResourceLocation fluidStill = fluid.getStill();
            TextureAtlasSprite fluidStillSprite = null;
            if (fluidStill != null) {
                fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
            }
            if (fluidStillSprite == null) {
                fluidStillSprite = textureMapBlocks.func_174944_f();
            }
            int fluidColor = fluid.getColor(fluidStack);
            int scaledAmount = this.height;
            if (this.capacityMb != -1) {
                scaledAmount = fluidStack.amount * this.height / this.capacityMb;
                if (fluidStack.amount > 0 && scaledAmount < 1) {
                    scaledAmount = 1;
                }
                if (scaledAmount > this.height) {
                    scaledAmount = this.height;
                }
            }
            minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(fluidColor);
            int xTileCount = this.width / 16;
            int xRemainder = this.width - xTileCount * 16;
            int yTileCount = scaledAmount / 16;
            int yRemainder = scaledAmount - yTileCount * 16;
            int yStart = yPosition + this.height;
            for (int xTile = 0; xTile <= xTileCount; ++xTile) {
                for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                    int width = xTile == xTileCount ? xRemainder : 16;
                    int height = yTile == yTileCount ? yRemainder : 16;
                    int x = xPosition + xTile * 16;
                    int y = yStart - (yTile + 1) * 16;
                    if (width <= 0 || height <= 0) continue;
                    int maskTop = 16 - height;
                    int maskRight = 16 - width;
                    RenderUtils.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
                }
            }
        }
    }

    public static class AdvancedRayTraceResult
    extends AdvancedRayTraceResultBase<RayTraceResult> {
        public AdvancedRayTraceResult(RayTraceResult mop, AxisAlignedBB bounds) {
            super(mop, bounds);
        }
    }

    private static class AdvancedRayTraceResultBase<T extends RayTraceResult> {
        public final AxisAlignedBB bounds;
        public final T hit;

        public AdvancedRayTraceResultBase(T mop, AxisAlignedBB bounds) {
            this.hit = mop;
            this.bounds = bounds;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3d vec) {
            return ((RayTraceResult)this.hit).field_72307_f.func_72436_e(vec);
        }
    }
}

