/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.armor;

import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemPrudentiumArmor
extends ItemArmor
implements IRepairMaterial {
    private ItemStack repairMaterial;

    public ItemPrudentiumArmor(String name, ItemArmor.ArmorMaterial material, int index, EntityEquipmentSlot slot) {
        super(material, index, slot);
        this.func_77655_b("ma." + name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + "\u00a7a" + damage);
        if (ModConfig.confSetBonuses) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a7a" + Tooltips.WATER_BREATHING);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (ModConfig.confSetBonuses && ItemPrudentiumArmor.isFullSet(player) && player.func_70090_H()) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 5, 0, true, false));
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public static boolean isFullSet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !head.func_190926_b() && head.func_77973_b() instanceof ItemPrudentiumArmor && !chest.func_190926_b() && chest.func_77973_b() instanceof ItemPrudentiumArmor && !legs.func_190926_b() && legs.func_77973_b() instanceof ItemPrudentiumArmor && !feet.func_190926_b() && feet.func_77973_b() instanceof ItemPrudentiumArmor;
    }
}

