/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.util.TileEntityUtil;
import com.blakebr0.mysticalagriculture.util.VanillaPacketDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntitySeedReprocessor
extends TileEntityUtil
implements ISidedInventory,
ITickable,
ICapabilityProvider {
    private ItemStack input = ItemStack.field_190927_a;
    private ItemStack processing = ItemStack.field_190927_a;
    private ItemStack output = ItemStack.field_190927_a;
    private int facing = 2;
    private int progress = 0;
    private int target = 0;
    private int time_left;
    private String ingredient;
    private int packetCount;
    private boolean packet;
    private static final int[] top = new int[]{0};
    private static final int[] sides = new int[]{1};

    public boolean timeLeft() {
        return this.getTimeLeft() > 0;
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag) {
        NBTTagCompound produce;
        tag.func_74768_a("TimeLeft", this.time_left);
        tag.func_74777_a("Facing", (short)this.facing);
        if (this.input == null) {
            this.input = ItemStack.field_190927_a;
        }
        if (this.input != null || !this.input.func_190926_b()) {
            produce = new NBTTagCompound();
            this.input.func_77955_b(produce);
            tag.func_74782_a("Input", (NBTBase)produce);
        } else {
            tag.func_82580_o("Input");
        }
        if (this.processing != null || !this.processing.func_190926_b()) {
            produce = new NBTTagCompound();
            this.processing.func_77955_b(produce);
            tag.func_74782_a("Processing", (NBTBase)produce);
            tag.func_74768_a("Progress", this.progress);
            if (this.ingredient != null) {
                tag.func_74778_a("Ingredient", this.ingredient);
            } else {
                tag.func_82580_o("Ingredient");
            }
        } else {
            tag.func_82580_o("Processing");
            tag.func_82580_o("Progress");
            tag.func_82580_o("Target");
            tag.func_82580_o("Ingredient");
        }
        if (this.output != null || !this.output.func_190926_b()) {
            produce = new NBTTagCompound();
            this.output.func_77955_b(produce);
            tag.func_74782_a("Output", (NBTBase)produce);
        } else {
            tag.func_82580_o("Output");
        }
        return tag;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.time_left = tag.func_74762_e("TimeLeft");
        this.input = new ItemStack(tag.func_74775_l("Input"));
        this.processing = new ItemStack(tag.func_74775_l("Processing"));
        this.output = new ItemStack(tag.func_74775_l("Output"));
        if (!this.processing.func_190926_b()) {
            this.target = ReprocessorManager.getPrice(this.processing);
            if (this.target != 0) {
                this.progress = tag.func_74762_e("Progress");
                if (tag.func_74764_b("Ingredient")) {
                    this.ingredient = tag.func_74779_i("Ingredient");
                }
            } else {
                this.processing = ItemStack.field_190927_a;
            }
        } else {
            this.progress = 0;
            this.target = 0;
            this.ingredient = null;
        }
        this.facing = tag.func_74765_d("Facing");
    }

    public void func_73660_a() {
        if (this.packetCount > 0) {
            --this.packetCount;
        }
        if (this.time_left > 0) {
            --this.time_left;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.time_left <= 0 && !this.input.func_190926_b() && this.processing.func_190926_b() && !ReprocessorManager.getOutput(this.input).func_190926_b() && (this.output.func_190926_b() || ReprocessorManager.getOutput(this.input).func_77969_a(this.output))) {
            if (this.processing.func_190926_b()) {
                this.processing = ReprocessorManager.getOutput(this.input);
                this.target = ReprocessorManager.getCost(this.input);
                this.ingredient = ReprocessorManager.getName(this.input);
                this.setTimeLeft(100);
            }
            if (ReprocessorManager.getOutput(this.input).func_77969_a(this.processing)) {
                int needed = this.target - this.progress;
                if (needed >= this.input.func_190916_E()) {
                    this.progress += this.input.func_190916_E();
                    this.input = ItemStack.field_190927_a;
                } else {
                    this.progress = this.target;
                    this.input.func_190918_g(needed);
                }
            }
            this.func_70296_d();
            this.packet = true;
        }
        if (this.time_left <= 0 && this.progress >= this.target && !this.processing.func_190926_b() && (this.output.func_190926_b() || this.output.func_77969_a(this.processing) && this.output.func_190916_E() + this.processing.func_190916_E() <= this.output.func_77976_d())) {
            if (this.output.func_190926_b()) {
                this.output = this.processing.func_77946_l();
            } else if (this.output.func_77969_a(this.processing)) {
                this.output.func_190920_e(this.output.func_190916_E() + this.processing.func_190916_E());
            }
            this.progress -= this.target;
            if (this.progress == 0) {
                this.processing = ItemStack.field_190927_a;
                this.ingredient = null;
            }
            this.func_70296_d();
            this.packet = true;
        }
        if (this.packet && this.packetCount <= 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.packetCount = 10;
            this.packet = false;
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int dir) {
        this.facing = dir;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getTarget() {
        return this.target;
    }

    public String getIngredient() {
        return this.ingredient;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        return this.output;
    }

    public ItemStack func_70298_a(int slot, int decrement) {
        if (slot == 0) {
            if (this.input.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (decrement < this.input.func_190916_E()) {
                ItemStack take = this.input.func_77979_a(decrement);
                if (this.input.func_190916_E() <= 0) {
                    this.input = ItemStack.field_190927_a;
                }
                return take;
            }
            ItemStack take = this.input;
            this.input = ItemStack.field_190927_a;
            return take;
        }
        if (slot == 1) {
            if (this.output.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (decrement < this.output.func_190916_E()) {
                ItemStack take = this.output.func_77979_a(decrement);
                if (this.output.func_190916_E() <= 0) {
                    this.output = ItemStack.field_190927_a;
                }
                return take;
            }
            ItemStack take = this.output;
            this.output = ItemStack.field_190927_a;
            return take;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0) {
            if (this.processing.func_190926_b()) {
                return true;
            }
            if (ReprocessorManager.getOutput(stack).func_190926_b()) {
                return false;
            }
            if (ReprocessorManager.getOutput(stack).func_77969_a(this.processing)) {
                return true;
            }
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.input = stack;
        } else if (slot == 1) {
            this.output = stack;
        }
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1 && side != 1;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (side == EnumFacing.DOWN) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 0;
            nArray = nArray4;
            nArray4[1] = 1;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public int getTimeLeft() {
        return this.time_left;
    }

    public void setTimeLeft(int time_left) {
        this.time_left = time_left;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

