/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.core;

import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.item.ItemGeneric;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.block.BlockPortal;
import me.ichun.mods.portalgun.common.core.ChunkLoadHandler;
import me.ichun.mods.portalgun.common.core.SoundIndex;
import me.ichun.mods.portalgun.common.item.ItemPortalGun;
import me.ichun.mods.portalgun.common.packet.PacketPortalChannelIndicator;
import me.ichun.mods.portalgun.common.portal.PortalGunHelper;
import me.ichun.mods.portalgun.common.portal.info.ChannelIndicator;
import me.ichun.mods.portalgun.common.portal.info.ChannelInfo;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.portal.world.PortalsInWorldSavedData;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EventHandlerServer {
    public ArrayList<ChannelIndicator> portalChannelsToUpdate = new ArrayList();
    public HashMap<String, ArrayList<ChannelIndicator>> portalChannelListeners = new HashMap();
    public HashMap<Integer, PortalsInWorldSavedData> portalInfoByDimension = new HashMap();

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)event.getPlayer());
        if (is.func_77973_b() == PortalGun.itemPortalGun) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (is.func_77973_b() == PortalGun.itemPortalGun) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack is = event.crafting;
        if (is.func_77969_a(PortalGun.itemPortalGunISInstance)) {
            ItemPortalGun.setRandomNBTTags(is, event.player);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityZombie zombie;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving() instanceof EntityZombie && (zombie = (EntityZombie)event.getEntityLiving()).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == PortalGun.itemPortalGun && zombie.func_70681_au().nextFloat() < 0.008f) {
            PortalGunHelper.shootPortal((EntityLivingBase)zombie, zombie.func_184586_b(EnumHand.MAIN_HAND), zombie.func_70681_au().nextBoolean());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.portalChannelsToUpdate.forEach(this::updatePortalChannelListeners);
            this.portalChannelsToUpdate.clear();
        }
    }

    public void updatePortalInfo(World world, PortalInfo info, boolean removal) {
        PortalsInWorldSavedData data = this.getWorldSaveData(world.field_73011_w.getDimension());
        data.updatePortalInfo(world, info, removal);
        ChannelIndicator indicator = data.getChannelIndicator(info.uuid, info.channelName, world.field_73011_w.getDimension(), this.getWorldSaveData(0).getChannel(info.uuid, info.channelName));
        if (info.isTypeA) {
            indicator.portalAAvailable = !removal;
        } else {
            boolean bl = indicator.portalBAvailable = !removal;
        }
        if (this.portalChannelsToUpdate.contains(indicator)) {
            this.portalChannelsToUpdate.remove(indicator);
        }
        this.portalChannelsToUpdate.add(indicator);
    }

    public ChannelIndicator getPortalChannelIndicator(EntityPlayer player, String uuid, String channel, int dimension) {
        String playerUuid = UUIDTypeAdapter.fromUUID((UUID)player.func_146103_bH().getId());
        ArrayList listeningChannels = this.portalChannelListeners.computeIfAbsent(playerUuid, k -> new ArrayList());
        ChannelIndicator indicatorToReturn = null;
        for (ChannelIndicator indicator : listeningChannels) {
            if (!indicator.info.uuid.equals(uuid) || !indicator.info.channelName.equals(channel)) continue;
            indicatorToReturn = indicator;
            break;
        }
        if (indicatorToReturn == null) {
            indicatorToReturn = this.getWorldSaveData(player.func_130014_f_().field_73011_w.getDimension()).getChannelIndicator(uuid, channel, dimension, this.getWorldSaveData(0).getChannel(uuid, channel));
            listeningChannels.add(indicatorToReturn);
        }
        return indicatorToReturn;
    }

    public void updatePortalChannelListeners(ChannelIndicator indicator) {
        block2: for (Map.Entry<String, ArrayList<ChannelIndicator>> e : this.portalChannelListeners.entrySet()) {
            for (ChannelIndicator listenedIndicator : e.getValue()) {
                UUID uuid;
                if (!listenedIndicator.equals(indicator)) continue;
                try {
                    uuid = UUIDTypeAdapter.fromString((String)e.getKey());
                }
                catch (IllegalArgumentException ex) {
                    uuid = EntityHelper.uuidExample;
                    PortalGun.LOGGER.error((Object)("This UUID wasn't valid. Game no likey: " + e.getKey()));
                    ex.printStackTrace();
                }
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
                if (player != null) {
                    PortalGun.channel.sendTo((AbstractPacket)new PacketPortalChannelIndicator(indicator.info.uuid, indicator.info.channelName, indicator.dimension, indicator.info.colourA, indicator.portalAAvailable, indicator.info.colourB, indicator.portalBAvailable), (EntityPlayer)player);
                    continue block2;
                }
                PortalGun.LOGGER.error((Object)"Uh oh, this shouldn't be happening! We can't find a player we're trying to updatePortalChannelListeners! We're telling EVERYONE then.");
                PortalGun.channel.sendToAll((AbstractPacket)new PacketPortalChannelIndicator(indicator.info.uuid, indicator.info.channelName, indicator.dimension, indicator.info.colourA, indicator.portalAAvailable, indicator.info.colourB, indicator.portalBAvailable));
            }
        }
    }

    public PortalsInWorldSavedData getWorldSaveData(int i) {
        PortalsInWorldSavedData data = this.portalInfoByDimension.get(i);
        if (data == null) {
            WorldServer world = DimensionManager.getWorld((int)i);
            data = world != null ? PortalGunHelper.getSaveDataForWorld((World)world) : new PortalsInWorldSavedData();
        }
        return data;
    }

    public ChannelInfo lookupChannel(String uuid, String channelName) {
        PortalsInWorldSavedData data = this.getWorldSaveData(0);
        return data.getChannel(uuid, channelName);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            this.portalInfoByDimension.remove(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.portalChannelListeners.remove(UUIDTypeAdapter.fromUUID((UUID)event.player.func_146103_bH().getId()));
    }

    @SubscribeEvent
    public void onEntityEnterChunk(EntityEvent.EnteringChunk event) {
        if (PortalGun.config.canPortalProjectilesChunkload == 1) {
            ChunkLoadHandler.checkAndCreateTicket(event);
        }
    }

    @SubscribeEvent
    public void onRegisterBlock(RegistryEvent.Register<Block> event) {
        PortalGun.blockPortal = ((Block)new BlockPortal().setRegistryName("portalgun", "block_portal")).func_149663_c("portalgun.block.portal").func_149711_c(0.0f).func_149715_a(0.675f).func_149752_b(10000.0f);
        event.getRegistry().register((IForgeRegistryEntry)PortalGun.blockPortal);
    }

    @SubscribeEvent
    public void onRegisterItem(RegistryEvent.Register<Item> event) {
        PortalGun.itemEnderPearlDust = ((Item)new ItemGeneric().setRegistryName("portalgun", "item_dust_ender_pearl")).func_77655_b("portalgun.item.dustEnderPearl").func_77637_a(CreativeTabs.field_78035_l);
        PortalGun.itemMiniatureBlackHole = ((Item)new ItemGeneric(){

            @SideOnly(value=Side.CLIENT)
            public boolean func_77636_d(ItemStack stack) {
                return true;
            }
        }.func_77625_d(1).setRegistryName("portalgun", "item_miniature_black_hole")).func_77655_b("portalgun.item.miniatureBlackHole").func_77637_a(CreativeTabs.field_78035_l);
        PortalGun.itemPortalGun = ((Item)new ItemPortalGun().func_77664_n().setRegistryName("portalgun", "item_portalgun")).func_77655_b("portalgun.item.portalgun").func_77637_a(CreativeTabs.field_78040_i);
        event.getRegistry().register((IForgeRegistryEntry)PortalGun.itemEnderPearlDust);
        event.getRegistry().register((IForgeRegistryEntry)PortalGun.itemMiniatureBlackHole);
        event.getRegistry().register((IForgeRegistryEntry)PortalGun.itemPortalGun);
        FurnaceRecipes.func_77602_a().func_151396_a(Items.field_151079_bi, new ItemStack(PortalGun.itemEnderPearlDust, 1), 0.15f);
        OreDictionary.registerOre((String)"dustEnderPearl", (Item)PortalGun.itemEnderPearlDust);
        PortalGun.itemPortalGunISInstance = new ItemStack(PortalGun.itemPortalGun, 1, 0);
    }

    @SubscribeEvent
    public void onRegisterSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        SoundIndex.init((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    public void onServerStopping() {
        this.portalChannelListeners.clear();
        this.portalInfoByDimension.clear();
        ChunkLoadHandler.entToTicketMap.clear();
    }
}

