/*
 * Decompiled with CFR 0.152.
 */
package rustic.client;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.models.BookBakedModel;
import rustic.client.models.LiquidBarrelItemModel;
import rustic.client.util.FluidClientUtil;
import rustic.common.Config;
import rustic.common.blocks.IAdvancedRotationPlacement;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.network.MessageVaseMeta;
import rustic.common.network.PacketHandler;

public class EventHandlerClient {
    public static ResourceLocation RUSTIC_ICONS = new ResourceLocation("rustic:textures/gui/icons.png");
    public static ResourceLocation OLIVE_OIL_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/olive_oil_overlay.png");
    public static ResourceLocation IRONBERRY_JUICE_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/ironberry_juice_overlay.png");
    public static ResourceLocation WILDBERRY_JUICE_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/wildberry_juice_overlay.png");
    public static ResourceLocation GRAPE_JUICE_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/grape_juice_overlay.png");
    public static ResourceLocation APPLE_JUICE_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/apple_juice_overlay.png");
    public static ResourceLocation ALE_WORT_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/ale_wort_overlay.png");
    public static ResourceLocation HONEY_OVERLAY = new ResourceLocation("rustic:textures/blocks/fluids/honey_overlay.png");
    private Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        FluidClientUtil.initTextures(event.getMap());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        Object customModel;
        IBakedModel existingModel;
        Object object = event.getModelRegistry().func_82594_a((Object)LiquidBarrelItemModel.modelResourceLocation);
        if (object instanceof IBakedModel) {
            existingModel = (IBakedModel)object;
            customModel = new LiquidBarrelItemModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)LiquidBarrelItemModel.modelResourceLocation, customModel);
        }
        if ((object = event.getModelRegistry().func_82594_a((Object)BookBakedModel.modelResourceLocation)) instanceof IBakedModel) {
            existingModel = (IBakedModel)object;
            customModel = new BookBakedModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)BookBakedModel.modelResourceLocation, customModel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onVaseMouseWheel(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70093_af() && player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)ModBlocks.VASE) && event.getDwheel() != 0) {
            event.setCanceled(true);
            int damage = (player.func_184614_ca().func_77952_i() - 0 + event.getDwheel() / 120) % 6 + 0;
            if (damage < 0) {
                damage = 5;
            }
            player.func_184614_ca().func_77964_b(damage);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageVaseMeta(damage));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFoodTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFood && stack.func_77942_o() && stack.func_77978_p().func_74764_b("oiled")) {
            event.getToolTip().add(TextFormatting.DARK_GREEN + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.rustic.olive_oil", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBoozeTooltip(ItemTooltipEvent event) {
        FluidStack fluid;
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFluidContainer && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null && fluid.getFluid() != null && fluid.getFluid() instanceof FluidBooze && fluid.tag != null && fluid.tag.func_150297_b("Quality", 5)) {
            float quality = fluid.tag.func_74760_g("Quality");
            event.getToolTip().add(TextFormatting.GOLD + "" + I18n.func_135052_a((String)"tooltip.rustic.quality", (Object[])new Object[0]) + quality);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderBlockOverlayEvent(RenderBlockOverlayEvent event) {
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayer player = event.getPlayer();
            BlockPos pos = event.getBlockPos().func_177963_a(0.0, (double)player.func_70047_e(), 0.0);
            IBlockState state = minecraft.field_71441_e.func_180495_p(pos);
            if (state.func_177230_c().equals((Object)ModFluids.BLOCK_OLIVE_OIL)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(OLIVE_OIL_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_IRONBERRY_JUICE)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(IRONBERRY_JUICE_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_WILDBERRY_JUICE)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(WILDBERRY_JUICE_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_GRAPE_JUICE)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(GRAPE_JUICE_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_APPLE_JUICE)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(APPLE_JUICE_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_ALE_WORT)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(ALE_WORT_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state.func_177230_c().equals((Object)ModFluids.BLOCK_HONEY)) {
                event.setCanceled(true);
                float brightness = player.func_70070_b();
                GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)0.99f);
                this.drawBlockOverlay(HONEY_OVERLAY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderArmorToughnessEvent(RenderGameOverlayEvent.Post event) {
        EntityLivingBase viewEntity;
        int armorToughness;
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && Minecraft.func_71410_x().func_175606_aa() instanceof EntityLivingBase && (armorToughness = MathHelper.func_76128_c((double)(viewEntity = (EntityLivingBase)Minecraft.func_71410_x().func_175606_aa()).func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e())) > 0 && Config.TOUGHNESS_HUD) {
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RUSTIC_ICONS);
            GlStateManager.func_179147_l();
            int toughnessRows = MathHelper.func_76123_f((float)((float)armorToughness / 20.0f));
            int rowHeight = Math.min(Math.max(10 - (toughnessRows - 2), 3), 10);
            int top = height - GuiIngameForge.right_height - (toughnessRows * rowHeight - 10);
            for (int i = toughnessRows - 1; i >= 0; --i) {
                int right = width / 2 + 82;
                for (int j = 1; armorToughness > 0 && j < 20; j += 2) {
                    if (j + i * 20 < armorToughness) {
                        gui.func_73729_b(right, top, 34, 0, 9, 9);
                    } else if (j + i * 20 == armorToughness) {
                        gui.func_73729_b(right, top, 25, 0, 9, 9);
                    } else if (j + i * 20 > armorToughness) {
                        gui.func_73729_b(right, top, 16, 0, 9, 9);
                    }
                    right -= 8;
                }
                top += rowHeight;
                GuiIngameForge.right_height += rowHeight;
            }
            if (rowHeight < 10) {
                GuiIngameForge.right_height += 10 - rowHeight;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderArmorOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR && Config.EXTRA_ARMOR_HUD && Minecraft.func_71410_x().func_175606_aa() instanceof EntityLivingBase) {
            EntityLivingBase viewEntity = (EntityLivingBase)Minecraft.func_71410_x().func_175606_aa();
            event.setCanceled(true);
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            Minecraft.func_71410_x().field_71424_I.func_76320_a("armor");
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179147_l();
            int armorLevel = viewEntity.func_70658_aO();
            int armorRows = MathHelper.func_76123_f((float)((float)armorLevel / 20.0f));
            int rowHeight = Math.min(Math.max(10 - (armorRows - 2), 3), 10);
            int top = height - GuiIngameForge.left_height - (armorRows * rowHeight - 10);
            for (int i = armorRows - 1; i >= 0; --i) {
                int left = width / 2 - 91;
                for (int j = 1; armorLevel > 0 && j < 20; j += 2) {
                    if (j + i * 20 < armorLevel) {
                        gui.func_73729_b(left, top, 34, 9, 9, 9);
                    } else if (j + i * 20 == armorLevel) {
                        gui.func_73729_b(left, top, 25, 9, 9, 9);
                    } else if (j + i * 20 > armorLevel) {
                        gui.func_73729_b(left, top, 16, 9, 9, 9);
                    }
                    left += 8;
                }
                top += rowHeight;
                GuiIngameForge.left_height += rowHeight;
            }
            if (rowHeight < 10) {
                GuiIngameForge.left_height += 10 - rowHeight;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = ItemStack.field_190927_a;
        if (!(!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemBlock || player.func_184586_b(EnumHand.OFF_HAND).func_190926_b())) {
            stack = player.func_184586_b(EnumHand.OFF_HAND);
        } else if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            stack = player.func_184586_b(EnumHand.MAIN_HAND);
        }
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && event.getTarget().field_178784_b.func_176740_k() == EnumFacing.Axis.Y && !stack.func_190926_b() && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IAdvancedRotationPlacement) {
            boolean isAABBCenteredXZ;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos pos = event.getTarget().func_178782_a();
            IBlockState iblockstate = player.func_130014_f_().func_180495_p(pos);
            AxisAlignedBB AABB = iblockstate.func_185900_c((IBlockAccess)player.func_130014_f_(), pos);
            boolean bl = isAABBCenteredXZ = !(AABB.field_72340_a + (AABB.field_72336_d - AABB.field_72340_a) / 2.0 != 0.5 && AABB.field_72336_d - (AABB.field_72336_d - AABB.field_72340_a) / 2.0 != 0.5 || AABB.field_72339_c + (AABB.field_72334_f - AABB.field_72339_c) / 2.0 != 0.5 && AABB.field_72334_f - (AABB.field_72334_f - AABB.field_72339_c) / 2.0 != 0.5);
            if (iblockstate.func_185904_a() != Material.field_151579_a && player.func_130014_f_().func_175723_af().func_177746_a(pos) && isAABBCenteredXZ) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                vertexbuffer.func_178969_c(-d0, -d1, -d2);
                AABB = AABB.func_186662_g((double)0.002f);
                this.drawRotablePlacementBlockHighlight(vertexbuffer, AABB, event.getTarget().field_178784_b, pos);
                tessellator.func_78381_a();
                vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawBlockOverlay(ResourceLocation location) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -Minecraft.func_71410_x().field_71439_g.field_70177_z / 64.0f;
        float f8 = Minecraft.func_71410_x().field_71439_g.field_70125_A / 64.0f;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
        vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRotablePlacementBlockHighlight(BufferBuilder buffer, AxisAlignedBB AABB, EnumFacing side, BlockPos pos) {
        double minXZ = Math.max(AABB.field_72340_a, AABB.field_72339_c);
        double maxXZ = Math.min(AABB.field_72336_d, AABB.field_72334_f);
        double y = side == EnumFacing.UP ? AABB.field_72337_e : AABB.field_72338_b;
        buffer.func_181662_b(minXZ + (double)pos.func_177958_n(), y += (double)pos.func_177956_o(), minXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(minXZ + (double)pos.func_177958_n(), y, minXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buffer.func_181662_b(maxXZ + (double)pos.func_177958_n(), y, maxXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buffer.func_181662_b(minXZ + (double)pos.func_177958_n(), y, maxXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(maxXZ + (double)pos.func_177958_n(), y, minXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buffer.func_181662_b(maxXZ + (double)pos.func_177958_n(), y, minXZ + (double)pos.func_177952_p()).func_181666_a(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
    }
}

