/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.crops;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.Config;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public abstract class BlockBerryBush
extends BlockBase
implements IColoredBlock,
IPlantable,
IGrowable {
    public static final PropertyBool BERRIES = PropertyBool.func_177716_a((String)"berries");
    protected static final AxisAlignedBB BUSH_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockBerryBush(String name) {
        super(Material.field_151585_k, name);
        this.func_149647_a(Rustic.farmingTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(false)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 40, 80);
    }

    public abstract Item getBerries();

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            if (!((Boolean)state.func_177229_b((IProperty)BERRIES)).booleanValue()) {
                float f = BlockBerryBush.getGrowthChance(this, worldIn, pos);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(true)), 3);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            } else {
                float f = BlockBerryBush.getGrowthChance(this, worldIn, pos);
                if (this.numNeighbors(worldIn, pos) < 2 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(100.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                    this.growOutward(worldIn, pos, rand);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        return 2.0f;
    }

    protected int numNeighbors(World world, BlockPos pos) {
        int n = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != this) continue;
                ++n;
            }
        }
        return n;
    }

    protected void growOutward(World world, BlockPos pos, Random rand) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || !this.func_176196_c(world, pos.func_177982_a(i, 0, j))) continue;
                positions.add(pos.func_177982_a(i, 0, j));
            }
        }
        if (positions.size() > 0) {
            BlockPos placePos = (BlockPos)positions.get(rand.nextInt(positions.size()));
            world.func_180501_a(placePos, this.func_176223_P(), 3);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List stacks = super.getDrops(world, pos, state, fortune);
        if (((Boolean)state.func_177229_b((IProperty)BERRIES)).booleanValue() && this.getBerries() != null) {
            stacks.add(new ItemStack(this.getBerries()));
        }
        return stacks;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)BERRIES)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(false)), 3);
            state.func_177230_c();
            Block.func_180635_a((World)world, (BlockPos)pos.func_177972_a(side), (ItemStack)new ItemStack(this.getBerries()));
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BUSH_AABB;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == ModBlocks.FERTILE_SOIL;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BERRIES) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BERRIES});
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)BERRIES) == false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BERRIES, (Comparable)Boolean.valueOf(true)), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        if (Config.OFFSET_WILDBERRY_BUSHES) {
            return Block.EnumOffsetType.XZ;
        }
        return Block.EnumOffsetType.NONE;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null && tintIndex == 1) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientProxy.addColoredBlock(this);
    }
}

