/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.fluids;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.blocks.fluids.FluidDrinkable;
import rustic.common.potions.PotionsRustic;

public class FluidBooze
extends FluidDrinkable {
    public static final String QUALITY_NBT_KEY = "Quality";
    private float inebriationChance = 0.5f;

    public FluidBooze(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        super(fluidName, still, flowing);
    }

    public FluidBooze setInebriationChance(float chance) {
        this.inebriationChance = chance;
        return this;
    }

    public float getInebriationChance() {
        return this.inebriationChance;
    }

    @Override
    public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
        float quality = this.getQuality(fluid);
        this.inebriate(world, player, quality);
        this.affectPlayer(world, player, quality);
    }

    protected void affectPlayer(World world, EntityPlayer player, float quality) {
    }

    public float getQuality(FluidStack fluid) {
        float quality = 0.0f;
        if (fluid.tag != null && fluid.tag.func_150297_b(QUALITY_NBT_KEY, 5)) {
            quality = fluid.tag.func_74760_g(QUALITY_NBT_KEY);
        }
        return Math.max(Math.min(quality, 1.0f), 0.0f);
    }

    protected void inebriate(World world, EntityPlayer player, float quality) {
        int duration = (int)(12000.0f * Math.max(1.0f - Math.abs(quality - 0.75f), 0.0f));
        float inebriationChanceMod = Math.max(Math.min(1.0f - Math.abs(0.67f * (quality - 0.75f)), 1.0f), 0.0f);
        PotionEffect tipsyEffect = player.func_70660_b(PotionsRustic.TIPSY);
        if (world.field_73012_v.nextFloat() < this.inebriationChance * inebriationChanceMod) {
            if (tipsyEffect == null) {
                player.func_70690_d(new PotionEffect(PotionsRustic.TIPSY, duration, 0, false, false));
            } else if (tipsyEffect.func_76458_c() < 3) {
                player.func_70690_d(new PotionEffect(PotionsRustic.TIPSY, duration, tipsyEffect.func_76458_c() + 1, false, false));
            }
        }
    }
}

