/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.book.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.gui.book.GuiBook;
import rustic.common.book.BookEntry;
import rustic.common.book.BookPage;

public class BookPageText
extends BookPage {
    protected List<String> textKeys = new ArrayList<String>();
    protected Set<BookEntry> relatedEntries = new HashSet<BookEntry>();

    public BookPageText(BookEntry entry, String ... textKeys) {
        super(entry);
        for (String textKey : textKeys) {
            this.textKeys.add("book.rustic.text." + textKey);
        }
    }

    @Override
    public void drawScreen(GuiBook gui, int mouseX, int mouseY, float partialTicks) {
        int y = gui.guiTop + 12;
        int x = gui.guiLeft + 146 / 2;
        int maxY = gui.guiTop + 180 - 19;
        gui.drawCenteredText(TextFormatting.UNDERLINE + "" + TextFormatting.BOLD + I18n.func_74838_a((String)this.entry.getName()), x, y, 0);
        y += gui.getFontRenderer().field_78288_b + 4;
        x = gui.guiLeft + 16;
        float textScale = 0.75f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        for (int i = 0; i < this.textKeys.size(); ++i) {
            String text = I18n.func_74838_a((String)this.textKeys.get(i));
            int increment = (int)((float)(gui.getFontRenderer().field_78288_b + 2) * textScale);
            List lines = gui.getFontRenderer().func_78271_c(text, (int)((float)(146 - 32) / textScale));
            for (String line : lines) {
                if (y + increment > maxY) break;
                gui.getFontRenderer().func_78276_b(line, (int)((float)x / textScale), (int)((float)y / textScale), 0);
                y += increment;
            }
            y += (int)(4.0f * textScale);
        }
        GlStateManager.func_179121_F();
        if (this.relatedEntries.size() > 0) {
            String text = TextFormatting.UNDERLINE + I18n.func_74838_a((String)"book.rustic.label.related_entries");
            int textWidth = gui.getFontRenderer().func_78256_a(text);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.field_146297_k.func_110434_K().func_110577_a(GuiBook.BOOK_BACKGROUND);
            gui.func_73729_b(gui.guiLeft + 146, gui.guiTop + 10, 136 - (textWidth + 2), 210, textWidth + 2 + 10, 16);
            gui.getFontRenderer().func_78276_b(text, gui.guiLeft + 146 + 2, gui.guiTop + 10 + 4, 0);
        }
    }

    @Override
    public void onOpened(GuiBook gui) {
        super.onOpened(gui);
        gui.addNavButtons();
        int x = gui.guiLeft + 146;
        int y = gui.guiTop + 10 + 16 + 2;
        int i = 0;
        for (BookEntry entry : this.relatedEntries) {
            if (i >= 9) continue;
            gui.getButtonList().add(new RelatedEntryButton(gui.nextButtonID(), x, y, gui.getFontRenderer(), entry));
            y += 16;
            ++i;
        }
    }

    @Override
    public void onClosed(GuiBook gui) {
        super.onClosed(gui);
    }

    @Override
    public void actionPerformed(GuiBook gui, GuiButton button) {
        if (button instanceof RelatedEntryButton) {
            gui.goToEntry(((RelatedEntryButton)button).getEntry());
        }
    }

    public BookPageText addRelatedEntry(BookEntry entry) {
        if (entry != null) {
            this.relatedEntries.add(entry);
        }
        return this;
    }

    public BookPageText addRelatedEntries(BookEntry ... entries) {
        for (BookEntry entry : entries) {
            if (entry == null) continue;
            this.relatedEntries.add(entry);
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public class RelatedEntryButton
    extends GuiButton {
        private static final int BASE_WIDTH = 24;
        private static final int BASE_HEIGHT = 16;
        private int ticksHovered;
        private FontRenderer fontRenderer;
        private final BookEntry entry;

        public RelatedEntryButton(int buttonId, int x, int y, FontRenderer fontRenderer, BookEntry entry) {
            super(buttonId, x, y, 24, 16, entry.getName());
            this.ticksHovered = 0;
            this.fontRenderer = fontRenderer;
            this.entry = entry;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag;
                String text = I18n.func_74838_a((String)this.field_146126_j);
                int textWidth = this.fontRenderer.func_78256_a(text);
                boolean bl = flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (flag) {
                    if (this.field_146120_f < 140 && this.field_146120_f < textWidth + 24 + 2) {
                        ++this.ticksHovered;
                        this.field_146120_f = Math.min(24 + this.ticksHovered * 8, Math.min(textWidth + 24 + 2, 144));
                    }
                } else {
                    this.ticksHovered = 0;
                    if (this.field_146120_f > 24) {
                        this.field_146120_f = Math.max(this.field_146120_f - 12, 24);
                    }
                }
                mc.func_110434_K().func_110577_a(GuiBook.BOOK_BACKGROUND);
                RelatedEntryButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)(146 - this.field_146120_f), (float)226.0f, (int)this.field_146120_f, (int)this.field_146121_g, (float)256.0f, (float)256.0f);
                text = this.fontRenderer.func_78262_a(text, this.field_146120_f - 24, true);
                textWidth = this.fontRenderer.func_78256_a(text);
                this.fontRenderer.func_78276_b(text, this.field_146128_h + (this.field_146120_f - 24) - textWidth, this.field_146129_i + 4, 0);
                if (this.entry != null && !this.entry.getIcon().func_190926_b()) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.func_74520_c();
                    mc.func_175599_af().func_175042_a(this.entry.getIcon(), this.field_146128_h + this.field_146120_f - 22, this.field_146129_i);
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179121_F();
                }
            }
        }

        public BookEntry getEntry() {
            return this.entry;
        }
    }
}

