/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.util;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rustic.common.blocks.BlockRope;
import rustic.common.blocks.ModBlocks;

public class DispenseRope
extends BehaviorDefaultDispenseItem {
    private static final DispenseRope INSTANCE = new DispenseRope();
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public static DispenseRope getInstance() {
        return INSTANCE;
    }

    private DispenseRope() {
    }

    @Nonnull
    public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        World world = source.func_82618_k();
        EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(facing);
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.ROPE) {
            if (this.addRope(world, pos)) {
                ItemStack ret = stack.func_77946_l();
                ret.func_190918_g(1);
                return ret;
            }
        } else if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == ModBlocks.ROPE && this.addRope(world, pos = pos.func_177972_a(facing))) {
            ItemStack ret = stack.func_77946_l();
            ret.func_190918_g(1);
            return ret;
        }
        return super.func_82487_b(source, stack);
    }

    private boolean addRope(World world, BlockPos pos) {
        int yOffset;
        for (yOffset = 1; yOffset < 64 && world.func_180495_p(pos.func_177979_c(yOffset)).func_177230_c() == ModBlocks.ROPE; ++yOffset) {
            if (world.func_180495_p(pos.func_177979_c(yOffset)).func_177229_b((IProperty)BlockRope.AXIS) == EnumFacing.Axis.Y) continue;
            return false;
        }
        if (ModBlocks.ROPE.func_176196_c(world, pos.func_177979_c(yOffset))) {
            IBlockState state = ModBlocks.ROPE.func_176223_P().func_177226_a((IProperty)BlockRope.AXIS, (Comparable)EnumFacing.Axis.Y);
            world.func_180501_a(pos.func_177979_c(yOffset), state, 3);
            SoundType soundType = ModBlocks.ROPE.getSoundType(state, world, pos, null);
            world.func_184134_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() - yOffset), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
            return true;
        }
        return false;
    }
}

