/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.FermenterRecipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import rustic.common.blocks.ModBlocks;
import rustic.common.items.ModItems;
import rustic.core.Rustic;

public class Compat {
    @Optional.Method(modid="forestry")
    public static void doForestryCompat() {
        if (FuelManager.bronzeEngineFuel != null) {
            Fluid fluid = FluidRegistry.getFluid((String)"honey");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 20, 20, 1));
            fluid = FluidRegistry.getFluid((String)"oliveoil");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 30, 30, 1));
            fluid = FluidRegistry.getFluid((String)"applejuice");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 10, 10, 1));
            fluid = FluidRegistry.getFluid((String)"grapejuice");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 10, 10, 1));
            fluid = FluidRegistry.getFluid((String)"ironberryjuice");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 10, 10, 1));
            fluid = FluidRegistry.getFluid((String)"wildberryjuice");
            FuelManager.bronzeEngineFuel.put(fluid, new EngineBronzeFuel(fluid, 10, 10, 1));
        }
        if (RecipeManagers.fermenterManager != null) {
            RecipeUtil.addFermenterRecipes((ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, 0), (int)250, (Fluids)Fluids.BIOMASS);
            RecipeUtil.addFermenterRecipes((ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, 1), (int)250, (Fluids)Fluids.BIOMASS);
            RecipeUtil.addFermenterRecipes((ItemStack)new ItemStack((Block)ModBlocks.APPLE_SAPLING, 1, 0), (int)250, (Fluids)Fluids.BIOMASS);
        }
        if (RecipeManagers.carpenterManager != null) {
            ArrayList<CarpenterRecipe> carpenterToAdd = new ArrayList<CarpenterRecipe>();
            for (ICarpenterRecipe iCarpenterRecipe : RecipeManagers.carpenterManager.recipes()) {
                ItemStack box;
                int packingTime;
                FluidStack fluid;
                ShapedRecipeCustom shapedRecipe;
                if (iCarpenterRecipe.getFluidResource() != null && iCarpenterRecipe.getFluidResource().getFluid().getName().equals("for.honey")) {
                    if (!(iCarpenterRecipe.getCraftingGridRecipe() instanceof ShapedRecipeCustom)) continue;
                    shapedRecipe = (ShapedRecipeCustom)iCarpenterRecipe.getCraftingGridRecipe();
                    fluid = new FluidStack(FluidRegistry.getFluid((String)"honey"), iCarpenterRecipe.getFluidResource().amount);
                    packingTime = iCarpenterRecipe.getPackagingTime();
                    box = iCarpenterRecipe.getBox();
                    carpenterToAdd.add(new CarpenterRecipe(packingTime, fluid, box, shapedRecipe));
                    continue;
                }
                if (iCarpenterRecipe.getFluidResource() == null || !iCarpenterRecipe.getFluidResource().getFluid().getName().equals("seed.oil") || !(iCarpenterRecipe.getCraftingGridRecipe() instanceof ShapedRecipeCustom)) continue;
                shapedRecipe = (ShapedRecipeCustom)iCarpenterRecipe.getCraftingGridRecipe();
                fluid = new FluidStack(FluidRegistry.getFluid((String)"oliveoil"), iCarpenterRecipe.getFluidResource().amount);
                packingTime = iCarpenterRecipe.getPackagingTime();
                box = iCarpenterRecipe.getBox();
                carpenterToAdd.add(new CarpenterRecipe(packingTime, fluid, box, shapedRecipe));
            }
            for (ICarpenterRecipe iCarpenterRecipe : carpenterToAdd) {
                RecipeManagers.carpenterManager.addRecipe((IForestryRecipe)iCarpenterRecipe);
            }
        }
        if (RecipeManagers.fermenterManager != null) {
            ArrayList<FermenterRecipe> fermenterToAdd = new ArrayList<FermenterRecipe>();
            for (IFermenterRecipe iFermenterRecipe : RecipeManagers.fermenterManager.recipes()) {
                String oreItemIn;
                ItemStack itemIn;
                float mod;
                int value;
                FluidStack fluidIn;
                Fluid fluidOut;
                if (iFermenterRecipe.getFluidResource() != null && iFermenterRecipe.getFluidResource().getFluid().getName().equals("for.honey")) {
                    fluidOut = iFermenterRecipe.getOutput();
                    fluidIn = new FluidStack(FluidRegistry.getFluid((String)"honey"), iFermenterRecipe.getFluidResource().amount);
                    value = iFermenterRecipe.getFermentationValue();
                    mod = iFermenterRecipe.getModifier();
                    itemIn = iFermenterRecipe.getResource();
                    oreItemIn = iFermenterRecipe.getResourceOreName();
                    if (!itemIn.func_190926_b()) {
                        fermenterToAdd.add(new FermenterRecipe(itemIn, value, mod, fluidOut, fluidIn));
                    } else if (!oreItemIn.isEmpty()) {
                        fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, mod, fluidOut, fluidIn));
                    }
                }
                if (iFermenterRecipe.getFluidResource() == null || !iFermenterRecipe.getFluidResource().getFluid().getName().equals("juice")) continue;
                fluidOut = iFermenterRecipe.getOutput();
                fluidIn = new FluidStack(FluidRegistry.getFluid((String)"applejuice"), iFermenterRecipe.getFluidResource().amount);
                value = iFermenterRecipe.getFermentationValue();
                mod = iFermenterRecipe.getModifier();
                itemIn = iFermenterRecipe.getResource();
                oreItemIn = iFermenterRecipe.getResourceOreName();
                if (!itemIn.func_190926_b()) {
                    fermenterToAdd.add(new FermenterRecipe(itemIn, value, mod, fluidOut, fluidIn));
                    fluidIn = new FluidStack(FluidRegistry.getFluid((String)"applejuice"), iFermenterRecipe.getFluidResource().amount);
                    fermenterToAdd.add(new FermenterRecipe(itemIn, value, mod, fluidOut, fluidIn));
                    fluidIn = new FluidStack(FluidRegistry.getFluid((String)"grapejuice"), iFermenterRecipe.getFluidResource().amount);
                    fermenterToAdd.add(new FermenterRecipe(itemIn, value, mod, fluidOut, fluidIn));
                    fluidIn = new FluidStack(FluidRegistry.getFluid((String)"ironberryjuice"), iFermenterRecipe.getFluidResource().amount);
                    fermenterToAdd.add(new FermenterRecipe(itemIn, value, 1.0f, fluidOut, fluidIn));
                    fluidIn = new FluidStack(FluidRegistry.getFluid((String)"wildberryjuice"), iFermenterRecipe.getFluidResource().amount);
                    fermenterToAdd.add(new FermenterRecipe(itemIn, value, 1.25f, fluidOut, fluidIn));
                    continue;
                }
                if (oreItemIn.isEmpty()) continue;
                fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, mod, fluidOut, fluidIn));
                fluidIn = new FluidStack(FluidRegistry.getFluid((String)"applejuice"), iFermenterRecipe.getFluidResource().amount);
                fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, mod, fluidOut, fluidIn));
                fluidIn = new FluidStack(FluidRegistry.getFluid((String)"grapejuice"), iFermenterRecipe.getFluidResource().amount);
                fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, mod, fluidOut, fluidIn));
                fluidIn = new FluidStack(FluidRegistry.getFluid((String)"ironberryjuice"), iFermenterRecipe.getFluidResource().amount);
                fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, 1.0f, fluidOut, fluidIn));
                fluidIn = new FluidStack(FluidRegistry.getFluid((String)"wildberryjuice"), iFermenterRecipe.getFluidResource().amount);
                fermenterToAdd.add(new FermenterRecipe(oreItemIn, value, 1.25f, fluidOut, fluidIn));
            }
            for (IFermenterRecipe iFermenterRecipe : fermenterToAdd) {
                RecipeManagers.fermenterManager.addRecipe((IForestryRecipe)iFermenterRecipe);
            }
        }
        if (RecipeManagers.squeezerManager != null) {
            if (FluidRegistry.getFluid((String)"seed.oil") != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.CHILI_PEPPER_SEEDS), new FluidStack(FluidRegistry.getFluid((String)"seed.oil"), 10));
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.TOMATO_SEEDS), new FluidStack(FluidRegistry.getFluid((String)"seed.oil"), 10));
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Block)ModBlocks.APPLE_SEEDS), new FluidStack(FluidRegistry.getFluid((String)"seed.oil"), 10));
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Block)ModBlocks.GRAPE_STEM), new FluidStack(FluidRegistry.getFluid((String)"seed.oil"), 10));
            }
            if (FluidRegistry.getFluid((String)"juice") != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.TOMATO), new FluidStack(FluidRegistry.getFluid((String)"juice"), 200));
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.CHILI_PEPPER), new FluidStack(FluidRegistry.getFluid((String)"juice"), 100));
            }
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.OLIVES), new FluidStack(FluidRegistry.getFluid((String)"oliveoil"), 250));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.IRONBERRIES), new FluidStack(FluidRegistry.getFluid((String)"ironberryjuice"), 250), new ItemStack((Item)ModItems.IRON_DUST_TINY), 5);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.WILDBERRIES), new FluidStack(FluidRegistry.getFluid((String)"wildberryjuice"), 250));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.GRAPES), new FluidStack(FluidRegistry.getFluid((String)"grapejuice"), 250));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack((Item)ModItems.HONEYCOMB), new FluidStack(FluidRegistry.getFluid((String)"honey"), 250));
        }
        Rustic.logger.info("Initialized Forestry compat module");
    }
}

