/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.api.locks;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.INBTSerializable;
import pl.asie.charset.api.lib.ICacheable;
import pl.asie.charset.api.locks.ILockingEntity;

public final class Lockable
implements ICacheable,
INBTSerializable<NBTTagCompound> {
    private final TileEntity owner;
    private ILockingEntity lock;

    public Lockable() {
        this(null);
    }

    public Lockable(TileEntity owner) {
        this.owner = owner;
    }

    public ILockingEntity getLock() {
        if (this.lock != null && !this.lock.isLockValid(null)) {
            this.lock = null;
        }
        return this.lock;
    }

    public boolean hasLock() {
        return this.getLock() != null;
    }

    public boolean addLock(ILockingEntity lock) {
        if (this.getLock() == null) {
            this.lock = lock;
            return true;
        }
        return false;
    }

    public boolean removeLock(ILockingEntity lock) {
        if (this.hasLock() && this.getLock() == lock) {
            this.lock = null;
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.hasLock()) {
            compound.func_74768_a("lockILockingEntityId", this.lock.getLockEntityId());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.lock = nbt.func_74764_b("lockILockingEntityId") && this.owner.func_145831_w() != null ? (ILockingEntity)this.owner.func_145831_w().func_73045_a(nbt.func_74762_e("lockILockingEntityId")) : null;
    }

    @Override
    public boolean isCacheValid() {
        return !this.owner.func_145837_r();
    }
}

