/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.audio;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.audio.PacketAudioData;
import pl.asie.charset.lib.audio.PacketAudioStop;
import pl.asie.charset.lib.audio.manager.AudioStreamManager;

public final class AudioUtils {
    private AudioUtils() {
    }

    public static void send(int id, AudioPacket audio) {
        if (audio.getVolume() <= 0.0f) {
            return;
        }
        PacketAudioData packet = new PacketAudioData(id, audio);
        HashMap worlds = new HashMap();
        for (AudioSink sink : audio.getSinks()) {
            if (sink.getVolume() <= 0.0f || sink.getDistance() <= 0.0f) continue;
            if (worlds.containsKey(sink.getWorld())) {
                ((Set)worlds.get(sink.getWorld())).add(sink);
                continue;
            }
            HashSet<AudioSink> sinkLocal = new HashSet<AudioSink>();
            sinkLocal.add(sink);
            worlds.put((WorldServer)sink.getWorld(), sinkLocal);
        }
        for (WorldServer world : worlds.keySet()) {
            block2: for (EntityPlayerMP player : world.func_73046_m().func_184103_al().func_181057_v()) {
                if (player.field_70170_p.field_73011_w.getDimension() != world.field_73011_w.getDimension()) continue;
                for (AudioSink sink : (Set)worlds.get(world)) {
                    BlockPos pos = new BlockPos(sink.getPos());
                    if (!world.func_184164_w().func_72694_a(player, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
                    CharsetLib.packet.sendTo(packet, (EntityPlayer)player);
                    continue block2;
                }
            }
        }
    }

    public static int start() {
        return AudioStreamManager.INSTANCE.create();
    }

    public static void stop(int id) {
        CharsetLib.packet.sendToAll(new PacketAudioStop(id));
        AudioStreamManager.INSTANCE.remove(id);
    }
}

