/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCache {
    protected final World world;
    protected final BlockPos pos;
    protected IBlockState state;
    protected boolean hasTile;
    private TileEntity tile;

    public TileCache(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void neighborChanged(BlockPos pos) {
        if (this.pos.equals((Object)pos)) {
            this.state = null;
        }
    }

    public void reload() {
        this.state = this.world.func_180495_p(this.pos);
        this.hasTile = this.state.func_177230_c().hasTileEntity(this.state);
        this.tile = null;
    }

    @Nonnull
    public IBlockState getBlock() {
        if (this.state == null || this.hasTile && this.tile.func_145837_r()) {
            this.reload();
        }
        return this.state;
    }

    @Nullable
    public TileEntity getTile() {
        if (this.state == null || this.tile != null && this.tile.func_145837_r()) {
            this.reload();
        }
        if (this.hasTile) {
            if (this.tile == null) {
                this.tile = this.world.func_175625_s(this.pos);
            }
            return this.tile;
        }
        return null;
    }
}

