/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.charset.lib.material.ItemMaterialRegistry;

public final class ItemMaterial {
    private final String id;
    private final ItemStack stack;

    protected ItemMaterial(ItemStack stack) {
        this.id = ItemMaterialRegistry.createId(stack);
        this.stack = stack;
    }

    public Collection<String> getTypes() {
        return ItemMaterialRegistry.INSTANCE.getMaterialTypes(this);
    }

    public Map<String, ItemMaterial> getRelations() {
        return ItemMaterialRegistry.INSTANCE.materialRelations.row((Object)this);
    }

    public ItemMaterial getRelated(String relation) {
        return (ItemMaterial)ItemMaterialRegistry.INSTANCE.materialRelations.get((Object)this, (Object)relation);
    }

    public String getId() {
        return this.id;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void writeToNBT(NBTTagCompound compound, String key) {
        compound.func_74778_a(key, this.id);
    }

    public String toString() {
        return "ItemMaterial[" + this.id + "]";
    }
}

