/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;

class ClientMessage {
    World world;
    Object locus;
    ItemStack item;
    ITextComponent msg;
    String msgRendered;
    Collection<NoticeStyle> style;
    long creationTime;
    long lifeTime;
    boolean position_important = false;
    boolean show_item = false;
    static final int SHORT_TIME = 6;
    static final int LONG_TIME = 11;
    static final int VERY_LONG_TIME = 60;

    public ClientMessage(World world, Object locus, ItemStack item, Collection<NoticeStyle> styles, ITextComponent msg) {
        this.world = world;
        this.locus = locus;
        this.item = item;
        this.msg = msg;
        this.style = styles;
        this.creationTime = System.currentTimeMillis();
        this.lifeTime = this.style.contains((Object)NoticeStyle.LONG) ? 11000L : 6000L;
        this.position_important = this.style.contains((Object)NoticeStyle.EXACTPOSITION);
        this.show_item = this.style.contains((Object)NoticeStyle.DRAWITEM) && !item.func_190926_b();
        this.translate();
    }

    void translate() {
        this.msgRendered = this.msg.func_150254_d();
        this.msgRendered = this.msgRendered.replace("\\n", "\n");
        String item_name = "null";
        StringBuilder item_info = new StringBuilder();
        if (this.item != null) {
            item_name = this.item.func_82833_r();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ArrayList<String> bits = new ArrayList<String>();
            try {
                this.item.func_77973_b().func_77624_a(this.item, player.func_130014_f_(), bits, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            }
            catch (Throwable t) {
                t.printStackTrace();
                bits.add("" + TextFormatting.RED + TextFormatting.BOLD + "ERROR");
            }
            boolean tail = false;
            for (String s : bits) {
                if (tail) {
                    item_info.append("\n");
                } else {
                    tail = true;
                }
                item_info.append(s);
            }
        }
        this.msgRendered = this.msgRendered.replace("{ITEM_NAME}", item_name);
        this.msgRendered = this.msgRendered.replace("{ITEM_INFOS}", item_info.toString());
    }

    static double interp(double old, double new_, float partial) {
        return old * (double)(1.0f - partial) + new_ * (double)partial;
    }

    Vec3d getPosition(float partial) {
        if (this.locus instanceof Vec3d) {
            return (Vec3d)this.locus;
        }
        if (this.locus instanceof Entity) {
            if (this.locus instanceof EntityMinecart) {
                partial = 1.0f;
            }
            Entity e = (Entity)this.locus;
            double w = (double)e.field_70130_N * -1.5;
            double eye_height = 0.25;
            if (e instanceof EntityLiving) {
                eye_height += (double)e.func_70047_e();
            }
            double x = ClientMessage.interp(e.field_70169_q, e.field_70165_t, partial) + w / 2.0;
            double y = ClientMessage.interp(e.field_70167_r, e.field_70163_u, partial) + eye_height;
            double z = ClientMessage.interp(e.field_70166_s, e.field_70161_v, partial) + w / 2.0;
            return new Vec3d(x, y, z);
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return new Vec3d((Vec3i)te.func_174877_v());
        }
        if (this.locus instanceof NotificationCoord) {
            return new Vec3d((Vec3i)((NotificationCoord)this.locus).getPos());
        }
        return null;
    }

    boolean stillValid() {
        if (this.locus instanceof Entity) {
            Entity e = (Entity)this.locus;
            return !e.field_70128_L;
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return !te.func_145837_r();
        }
        return true;
    }

    @Nullable
    public NotificationCoord asCoord() {
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return new NotificationCoord(te.func_145831_w(), te.func_174877_v());
        }
        if (this.locus instanceof NotificationCoord) {
            return new NotificationCoord(((NotificationCoord)this.locus).getWorld(), ((NotificationCoord)this.locus).getPos());
        }
        return null;
    }
}

