/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.notify.ClientMessage;
import pl.asie.charset.lib.notify.CommandPoint;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.NotifyProxy;

public class NotifyProxyClient
extends NotifyProxy {
    static final List<ClientMessage> messages = Collections.synchronizedList(new ArrayList());
    private RenderItem renderItem = null;

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(Object locus, ItemStack item, Collection<NoticeStyle> style, ITextComponent msg) {
        List<ClientMessage> list = messages;
        synchronized (list) {
            this.addMessage0(locus, item, style, msg);
        }
    }

    private void addMessage0(Object locus, ItemStack item, Collection<NoticeStyle> style, ITextComponent cmsg) {
        Vec3d testPos;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ClientMessage msg = new ClientMessage(player.field_70170_p, locus, item, style, cmsg);
        if (msg.style.contains((Object)NoticeStyle.CLEAR)) {
            messages.clear();
            if (msg.msg == null || msg.msg.equals("")) {
                return;
            }
        }
        if (msg.style.contains((Object)NoticeStyle.UPDATE) || msg.style.contains((Object)NoticeStyle.UPDATE_SAME_ITEM)) {
            this.updateMessage(msg);
            return;
        }
        boolean force_position = msg.style.contains((Object)NoticeStyle.FORCE);
        if (messages.size() > 4 && !force_position) {
            messages.remove(0);
        }
        if ((testPos = msg.getPosition(0.0f)) == null) {
            return;
        }
        for (ClientMessage m : messages) {
            if (!(m.getPosition(0.0f).func_72438_d(testPos) < 1.05) || force_position) continue;
            m.creationTime = 0L;
        }
        if (!(msg.msg != null && msg.msgRendered.trim().length() != 0 || msg.show_item && msg.item != null)) {
            return;
        }
        messages.add(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessage(ClientMessage update) {
        List<ClientMessage> list = messages;
        synchronized (list) {
            this.updateMessage0(update);
        }
    }

    private void updateMessage0(ClientMessage update) {
        for (ClientMessage msg : messages) {
            if (!msg.locus.equals(update.locus)) continue;
            if (!update.style.contains((Object)NoticeStyle.UPDATE_SAME_ITEM)) {
                msg.item = update.item;
            }
            msg.msg = update.msg;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderMessages(RenderWorldLastEvent event) {
        List<ClientMessage> list = messages;
        synchronized (list) {
            this.renderMessages0(event);
        }
    }

    void renderMessages0(RenderWorldLastEvent event) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        if (messages.size() == 0) {
            return;
        }
        Iterator<ClientMessage> it = messages.iterator();
        long approximateNow = System.currentTimeMillis();
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.getPartialTicks();
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.getPartialTicks();
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-cx), (double)(-cy), (double)(-cz));
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.renderItem == null) {
            this.renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        while (it.hasNext()) {
            ClientMessage m = it.next();
            long timeExisted = approximateNow - m.creationTime;
            if (timeExisted > m.lifeTime || m.world != w || !m.stillValid()) {
                it.remove();
                continue;
            }
            if (!m.style.contains((Object)NoticeStyle.DRAWFAR)) {
                Vec3d pos = m.getPosition(event.getPartialTicks());
                double dist = camera.func_70011_f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                if (dist > 8.0) continue;
            }
            float lifeLeft = (float)(m.lifeTime - timeExisted) / 1000.0f;
            float opacity = 1.0f;
            if (lifeLeft < 1.0f) {
                opacity = lifeLeft / 1.0f;
            }
            if (!((double)(opacity = (float)Math.sin(opacity)) > 0.12)) continue;
            this.renderMessage(m, event.getPartialTicks(), opacity, cx, cy, cz);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void renderMessage(ClientMessage m, float partial, float opacity, double cx, double cy, double cz) {
        NotificationCoord co;
        int width = 0;
        String[] lines = m.msgRendered.split("\n");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        for (String line : lines) {
            width = Math.max(width, fr.func_78256_a(line));
        }
        int halfWidth = (width += 2) / 2;
        float scaling = 0.026666667f;
        scaling *= 0.6666667f;
        GlStateManager.func_179094_E();
        int lineCount = lines.length;
        float centeringOffset = 0.0f;
        if (m.show_item) {
            if (lineCount == 1) {
                centeringOffset = 5.0f;
            }
            lineCount = Math.max(2, lineCount);
        }
        Vec3d vec = m.getPosition(partial);
        float x = (float)vec.field_72450_a;
        float y = (float)vec.field_72448_b;
        float z = (float)vec.field_72449_c;
        if (m.style.contains((Object)NoticeStyle.SCALE_SIZE)) {
            double dx = (double)x - cx;
            double dy = (double)y - cy;
            double dz = (double)z - cz;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            scaling = (float)((double)scaling * Math.sqrt(dist));
        }
        if ((co = m.asCoord()) != null && !m.position_important) {
            BlockPos pos = co.getPos();
            IBlockState bs = co.getWorld().func_180495_p(pos);
            AxisAlignedBB bb = bs.func_185890_d((IBlockAccess)co.getWorld(), pos);
            y = bb != null ? (float)((double)y + (bb.field_72337_e - bb.field_72338_b)) : (y += 0.5f);
        }
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        Minecraft mc = Minecraft.func_71410_x();
        float pvx = mc.func_175598_ae().field_78732_j;
        float pvy = -mc.func_175598_ae().field_78735_i;
        if (mc.field_71474_y.field_74320_O == 2) {
            pvx = -pvx;
        }
        GlStateManager.func_179114_b((float)pvy, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pvx, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scaling), (float)(-scaling), (float)scaling);
        GlStateManager.func_179109_b((float)0.0f, (float)(-10 * lineCount), (float)0.0f);
        int lineHeight = (lineCount - 1) * 10;
        double item_add = 0.0;
        if (m.show_item) {
            item_add += 24.0;
        }
        float c = 0.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)c, (float)c, (float)c, (float)Math.min(opacity, 0.2f));
        double Z = 0.001;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)(-halfWidth - 1), -1.0, Z).func_181675_d();
        worldrenderer.func_181662_b((double)(-halfWidth - 1), (double)(8 + lineHeight), Z).func_181675_d();
        worldrenderer.func_181662_b((double)(halfWidth + 1) + item_add, (double)(8 + lineHeight), Z).func_181675_d();
        worldrenderer.func_181662_b((double)(halfWidth + 1) + item_add, -1.0, Z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        int i = 0;
        int B = (int)(255.0f * Math.min(1.0f, 0.5f + opacity));
        int color = (B << 16) + (B << 8) + B + ((int)(255.0f * opacity) << 24);
        GlStateManager.func_179109_b((float)0.0f, (float)centeringOffset, (float)0.0f);
        for (String line : lines) {
            fr.func_78276_b(line, -fr.func_78256_a(line) / 2, 10 * i, color);
            ++i;
        }
        if (m.show_item) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-centeringOffset), (float)0.0f);
            GlStateManager.func_179109_b((float)(halfWidth + 4), (float)(-lineCount / 2), (float)0.0f);
            this.renderItem.field_77023_b -= 100.0f;
            this.renderItem.func_175042_a(m.item, 0, 0);
            this.renderItem.field_77023_b += 100.0f;
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void onscreen(Collection<NoticeStyle> style, ITextComponent msg) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71456_v.func_175188_a(msg, false);
    }
}

