/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.NotifyImplementation;

public class PacketNotification
extends Packet {
    private Type type;
    private BlockPos pos;
    private Object target;
    private ItemStack item;
    private Collection<NoticeStyle> style;
    private ITextComponent msg;
    private EntityPlayer me;

    public static PacketNotification createOnscreen(Collection<NoticeStyle> style, ITextComponent message) {
        PacketNotification n = new PacketNotification();
        n.type = Type.ONSCREEN;
        n.style = style;
        n.msg = message;
        return n;
    }

    public static PacketNotification createNotify(Object where, ItemStack item, Collection<NoticeStyle> style, ITextComponent message) {
        PacketNotification n = new PacketNotification();
        if (where instanceof NotificationCoord) {
            where = ((NotificationCoord)where).getPos();
        }
        n.target = where;
        if (where instanceof Vec3d) {
            n.type = Type.VEC3;
        } else if (where instanceof BlockPos) {
            n.type = Type.COORD;
        } else if (where instanceof Entity) {
            n.type = Type.ENTITY;
        } else if (where instanceof TileEntity) {
            n.type = Type.TILEENTITY;
        } else {
            return null;
        }
        n.item = item;
        n.style = style;
        n.msg = message;
        return n;
    }

    private void writeStyles(PacketBuffer output) {
        output.writeByte(this.style.size());
        for (NoticeStyle s : this.style) {
            output.writeByte(s.ordinal());
        }
    }

    private void readStyles(PacketBuffer input) {
        this.style = EnumSet.noneOf(NoticeStyle.class);
        int size = input.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            this.style.add(NoticeStyle.values()[input.readUnsignedByte()]);
        }
    }

    private void readMsg(PacketBuffer input) {
        try {
            this.msg = input.func_179258_d();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.msg = new TextComponentString("#ERR");
        }
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer input) {
        this.me = PacketNotification.getPlayer(handler);
        this.type = Type.VALUES[input.readByte()];
        switch (this.type) {
            case COORD: {
                this.pos = new BlockPos(input.readInt(), input.readInt(), input.readInt());
                this.target = new NotificationCoord(this.me.field_70170_p, this.pos);
                break;
            }
            case ENTITY: {
                int id = input.readInt();
                if (id == this.me.func_145782_y()) {
                    this.target = this.me;
                    break;
                }
                this.target = this.me.field_70170_p.func_73045_a(id);
                break;
            }
            case TILEENTITY: {
                this.pos = new BlockPos(input.readInt(), input.readInt(), input.readInt());
                this.target = this.me.field_70170_p.func_175625_s(this.pos);
                if (this.target != null) break;
                this.target = new NotificationCoord(this.me.field_70170_p, this.pos);
                break;
            }
            case VEC3: {
                this.target = new Vec3d(input.readDouble(), input.readDouble(), input.readDouble());
                break;
            }
            case ONSCREEN: {
                this.readStyles(input);
                this.readMsg(input);
                return;
            }
            default: {
                return;
            }
        }
        if (this.target == null) {
            return;
        }
        this.item = ByteBufUtils.readItemStack((ByteBuf)input);
        this.readStyles(input);
        this.readMsg(input);
    }

    @Override
    public void apply(INetHandler handler) {
        switch (this.type) {
            case ONSCREEN: {
                NotifyImplementation.proxy.onscreen(this.style, this.msg);
                break;
            }
            default: {
                NotifyImplementation.recieve(this.me, this.target, this.item, this.style, this.msg);
            }
        }
    }

    @Override
    public void writeData(PacketBuffer output) {
        output.writeByte(this.type.ordinal());
        switch (this.type) {
            case COORD: {
                BlockPos pos = (BlockPos)this.target;
                output.writeInt(pos.func_177958_n());
                output.writeInt(pos.func_177956_o());
                output.writeInt(pos.func_177952_p());
                break;
            }
            case VEC3: {
                Vec3d v = (Vec3d)this.target;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
                break;
            }
            case ENTITY: {
                Entity ent = (Entity)this.target;
                output.writeInt(ent.func_145782_y());
                break;
            }
            case TILEENTITY: {
                TileEntity te = (TileEntity)this.target;
                output.writeInt(te.func_174877_v().func_177958_n());
                output.writeInt(te.func_174877_v().func_177956_o());
                output.writeInt(te.func_174877_v().func_177952_p());
                break;
            }
            case ONSCREEN: {
                this.writeStyles(output);
                output.func_179256_a(this.msg);
                return;
            }
        }
        ByteBufUtils.writeItemStack((ByteBuf)output, (ItemStack)this.item);
        this.writeStyles(output);
        output.func_179256_a(this.msg);
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    static enum Type {
        COORD,
        VEC3,
        ENTITY,
        TILEENTITY,
        ONSCREEN;

        static Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

