/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.recipe.IngredientCharset;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.utils.ItemUtils;

public class IngredientMaterialFactory
implements IIngredientFactory {
    @Nonnull
    public IngredientMaterial parse(JsonContext jsonContext, JsonObject jsonObject) {
        String[] material;
        String tag = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"nbtKey");
        JsonElement oreElem = jsonObject.get("material");
        if (oreElem instanceof JsonArray) {
            JsonArray array = oreElem.getAsJsonArray();
            material = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                material[i] = array.get(i).getAsString();
            }
        } else {
            material = new String[]{JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"material")};
        }
        if (jsonObject.has("chain")) {
            return new IngredientMaterial(tag, JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"chain"), false, material);
        }
        return new IngredientMaterial(tag, material);
    }

    public static class IngredientMaterial
    extends IngredientCharset {
        private final String[] chain;
        private final TCharSet dependencies;
        private final String[] types;
        private final String nbtTag;
        private Ingredient dependency;

        protected IngredientMaterial(String nbtTag, String ... types) {
            super(0);
            this.types = types;
            this.nbtTag = nbtTag;
            this.chain = null;
            this.dependencies = null;
        }

        protected IngredientMaterial(String nbtTag, String chain, boolean dummy, String ... types) {
            super(0);
            this.types = types;
            this.nbtTag = nbtTag;
            this.chain = chain.split("\\.");
            this.dependencies = new TCharHashSet();
            this.dependencies.add(this.chain[0].charAt(0));
        }

        @Override
        public TCharSet getDependencies() {
            return this.dependencies;
        }

        @Override
        public void addDependency(char c, Ingredient i) {
            if (this.chain != null && c == this.chain[0].charAt(0)) {
                this.dependency = i;
            }
        }

        @Override
        public boolean mustIteratePermutations() {
            return super.mustIteratePermutations() || this.chain != null || this.nbtTag != null;
        }

        private ItemMaterial getChainedMaterial(ItemMaterial base) {
            for (int i = 1; i < this.chain.length; ++i) {
                if (this.chain[i].charAt(0) == '?') {
                    ItemMaterial nextBase = base.getRelated(this.chain[i].substring(1));
                    if (nextBase == null) continue;
                    base = nextBase;
                    continue;
                }
                if ((base = base.getRelated(this.chain[i])) != null) continue;
                return null;
            }
            return base;
        }

        @Override
        public boolean apply(IngredientMatcher matcher, ItemStack stack) {
            if (this.chain != null) {
                ItemStack stackIn = matcher.getStack(this.dependency);
                if (!stackIn.func_190926_b()) {
                    ItemMaterial base = this.getChainedMaterial(ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(stackIn));
                    return base != null && ItemMaterialRegistry.INSTANCE.matches(stack, base);
                }
                return false;
            }
            return this.apply(stack);
        }

        @Override
        public void applyToStack(ItemStack stack, ItemStack source) {
            if (this.nbtTag != null) {
                ItemUtils.getTagCompound(stack, true).func_74778_a(this.nbtTag, ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(source).getId());
            }
        }

        public ItemStack[] func_193365_a() {
            if (this.chain != null) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : this.dependency.func_193365_a()) {
                    ItemMaterial materialOut = this.getChainedMaterial(ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(stack));
                    if (materialOut == null) continue;
                    stacks.add(materialOut.getStack());
                }
                return stacks.toArray(new ItemStack[stacks.size()]);
            }
            Collection<ItemMaterial> mats = ItemMaterialRegistry.INSTANCE.getMaterialsByTypes(this.types);
            ItemStack[] stacks = new ItemStack[mats.size()];
            int idx = 0;
            for (ItemMaterial material : mats) {
                stacks[idx++] = material.getStack();
            }
            return stacks;
        }

        public boolean apply(@Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return ItemMaterialRegistry.INSTANCE.matches(stack, this.types);
        }
    }
}

