/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import gnu.trove.map.TCharObjectMap;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.utils.ItemStackHashSet;

public class RecipeReplacement {
    public static final RecipeReplacement PRIMARY = new RecipeReplacement();
    private final Map<ItemStack, Object> replacements = new TCustomHashMap((HashingStrategy)new ItemStackHashSet.Strategy(false, true, true));
    private final Map<Item, Object> replaceableItems = new IdentityHashMap<Item, Object>();

    public void add(ItemStack from, ItemStack to) {
        if (from.func_77952_i() == Short.MAX_VALUE) {
            this.replaceableItems.put(from.func_77973_b(), to.func_77973_b());
        } else {
            this.replacements.put(from, to);
        }
    }

    public void add(Item from, Item to) {
        this.replaceableItems.put(from, to);
    }

    @Nullable
    private Ingredient replaceIngredient(Ingredient ing) {
        if (ing.getClass() == Ingredient.class) {
            ItemStack[] matchingStacks = ing.func_193365_a();
            ItemStack[] matchingStacksNew = null;
            boolean dirty = false;
            for (int j = 0; j < matchingStacks.length; ++j) {
                ItemStack stack = matchingStacks[j];
                ItemStack newStack = null;
                Object replacement = null;
                if (this.replaceableItems.containsKey(stack.func_77973_b())) {
                    replacement = this.replaceableItems.get(stack.func_77973_b());
                } else if (this.replacements.containsKey(stack)) {
                    replacement = this.replacements.get(stack);
                }
                if (replacement instanceof Item) {
                    newStack = new ItemStack((Item)replacement, stack.func_190916_E(), stack.func_77952_i());
                    newStack.func_77982_d(stack.func_77978_p());
                } else if (replacement instanceof ItemStack) {
                    newStack = ((ItemStack)this.replacements.get(stack)).func_77946_l();
                    newStack.func_190920_e(stack.func_190916_E());
                } else if (replacement instanceof String) {
                    // empty if block
                }
                if (newStack == null) continue;
                if (!dirty) {
                    matchingStacksNew = new ItemStack[matchingStacks.length];
                    System.arraycopy(matchingStacks, 0, matchingStacksNew, 0, matchingStacks.length);
                    dirty = true;
                }
                matchingStacksNew[j] = newStack;
            }
            if (matchingStacksNew != null) {
                return Ingredient.func_193369_a(matchingStacksNew);
            }
        }
        return null;
    }

    public void process(Collection<IRecipe> registry) {
        for (IRecipe recipe : registry) {
            ResourceLocation recipeName = recipe.getRegistryName();
            boolean dirty = false;
            if (recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes) {
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing = (Ingredient)ingredients.get(i);
                    Ingredient ingNew = this.replaceIngredient(ing);
                    if (ingNew == null) continue;
                    ingredients.set(i, (Object)ingNew);
                    dirty = true;
                }
            } else if (recipe instanceof RecipeCharset) {
                TCharObjectMap<Ingredient> charToIngredient = ((RecipeCharset)recipe).charToIngredient;
                NonNullList ingredients = recipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing = (Ingredient)ingredients.get(i);
                    Ingredient ingNew = this.replaceIngredient(ing);
                    if (ingNew == null) continue;
                    ingredients.set(i, (Object)ingNew);
                    for (char c : charToIngredient.keySet()) {
                        if (charToIngredient.get(c) != ing) continue;
                        charToIngredient.put(c, (Object)ing);
                    }
                    dirty = true;
                }
            }
            if (!dirty) continue;
            ModCharset.logger.info("Successfully edited " + recipeName + "!");
        }
    }
}

