/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class FluidHandlerHelper {
    private FluidHandlerHelper() {
    }

    public static boolean matches(IFluidHandler handler, FluidStack stack) {
        IFluidTankProperties[] properties = handler.getTankProperties();
        if (properties != null) {
            for (IFluidTankProperties property : properties) {
                FluidStack match = property.getContents();
                if (!match.isFluidEqual(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int push(IFluidHandler from, IFluidHandler to, int amt) {
        FluidStack drained;
        if (amt > 0 && (drained = from.drain(amt, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained.copy();
            toDrain.amount = amt;
            FluidStack drainedReal = from.drain(toDrain, true);
            return drainedReal.amount;
        }
        return 0;
    }

    public static int push(IFluidHandler from, IFluidHandler to, FluidStack pushed) {
        int amt;
        FluidStack drained;
        if (pushed != null && pushed.amount > 0 && (drained = from.drain(pushed, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained;
            toDrain.amount = amt;
            FluidStack drainedReal = from.drain(toDrain, true);
            return drainedReal.amount;
        }
        return 0;
    }
}

