/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.render.CharsetFaceBakery;

public final class RenderUtils {
    public static final CharsetFaceBakery BAKERY = new CharsetFaceBakery();
    public static final Function<ResourceLocation, TextureAtlasSprite> textureGetter = ModelLoader.defaultTextureGetter();
    private static RenderItem renderItem;

    private RenderUtils() {
    }

    public static BakedQuad createQuad(Vector3f from, Vector3f to, @Nonnull EnumFacing facing, TextureAtlasSprite sprite, int tintIndex) {
        Vector3f fFrom = new Vector3f((ReadableVector3f)from);
        Vector3f fTo = new Vector3f((ReadableVector3f)to);
        EnumFacing.AxisDirection facingDir = facing.func_176743_c();
        switch (facing.func_176740_k()) {
            case X: {
                fTo.x = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.x : from.x;
                fFrom.x = fTo.x;
                break;
            }
            case Y: {
                fTo.y = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.y : from.y;
                fFrom.y = fTo.y;
                break;
            }
            case Z: {
                fTo.z = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.z : from.z;
                fFrom.z = fTo.z;
            }
        }
        return BAKERY.makeBakedQuad(fFrom, fTo, tintIndex, sprite, facing, ModelRotation.X0_Y0, true);
    }

    public static int getAverageColor(TextureAtlasSprite sprite, AveragingMode mode) {
        int i;
        int pixelCount = 0;
        int[] data = sprite.func_147965_a(0)[0];
        long[] avgColor = new long[3];
        switch (mode) {
            case FULL: {
                int c;
                int j;
                for (j = 0; j < sprite.func_94216_b(); ++j) {
                    for (i = 0; i < sprite.func_94211_a(); ++i) {
                        c = data[j * sprite.func_94211_a() + i];
                        if ((c >> 24 & 0xFF) <= 0) continue;
                        avgColor[0] = avgColor[0] + (long)((c & 0xFF) * (c & 0xFF));
                        avgColor[1] = avgColor[1] + (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColor[2] = avgColor[2] + (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
            case H_EDGES_ONLY: {
                int c;
                int j;
                for (j = 0; j < 2; ++j) {
                    for (i = 0; i < sprite.func_94216_b(); ++i) {
                        c = data[i * sprite.func_94211_a() + (j > 0 ? sprite.func_94211_a() - 1 : 0)];
                        if ((c >> 24 & 0xFF) <= 0) continue;
                        avgColor[0] = avgColor[0] + (long)((c & 0xFF) * (c & 0xFF));
                        avgColor[1] = avgColor[1] + (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColor[2] = avgColor[2] + (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
            case V_EDGES_ONLY: {
                int c;
                int j;
                for (j = 0; j < 2; ++j) {
                    for (i = 0; i < sprite.func_94211_a(); ++i) {
                        c = data[j > 0 ? data.length - 1 - i : i];
                        if ((c >> 24 & 0xFF) <= 0) continue;
                        avgColor[0] = avgColor[0] + (long)((c & 0xFF) * (c & 0xFF));
                        avgColor[1] = avgColor[1] + (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColor[2] = avgColor[2] + (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
        }
        int col = -16777216;
        for (i = 0; i < 3; ++i) {
            col |= ((int)Math.min(255L, Math.round(Math.sqrt(avgColor[i] / (long)pixelCount))) & 0xFF) << i * 8;
        }
        return col;
    }

    public static BufferedImage getTextureImage(ResourceLocation location) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            ResourceLocation pngLocation = new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(pngLocation);
            return TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TextureAtlasSprite getItemSprite(ItemStack stack) {
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return renderItem.func_184393_a(stack, null, null).func_177554_e();
    }

    public static boolean isBuiltInRenderer(World world, ItemStack stack) {
        IBakedModel model;
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return (model = renderItem.func_184393_a(stack, world, null)) != null && model.func_188618_c();
    }

    public static void glColor(int color) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static float[] calculateUV(Vector3f from, Vector3f to, EnumFacing facing1) {
        EnumFacing facing;
        if (to.y > 16.0f) {
            from = new Vector3f((ReadableVector3f)from);
            to = new Vector3f((ReadableVector3f)to);
            while (to.y > 16.0f) {
                from.y -= 16.0f;
                to.y -= 16.0f;
            }
        }
        if ((facing = facing1) == null) {
            if (from.y == to.y) {
                facing = EnumFacing.UP;
            } else if (from.x == to.x) {
                facing = EnumFacing.EAST;
            } else if (from.z == to.z) {
                facing = EnumFacing.SOUTH;
            } else {
                return null;
            }
        }
        switch (facing) {
            case DOWN: {
                return new float[]{from.x, 16.0f - to.z, to.x, 16.0f - from.z};
            }
            case UP: {
                return new float[]{from.x, from.z, to.x, to.z};
            }
            case NORTH: {
                return new float[]{16.0f - to.x, 16.0f - to.y, 16.0f - from.x, 16.0f - from.y};
            }
            case SOUTH: {
                return new float[]{from.x, 16.0f - to.y, to.x, 16.0f - from.y};
            }
            case WEST: {
                return new float[]{from.z, 16.0f - to.y, to.z, 16.0f - from.y};
            }
            case EAST: {
                return new float[]{16.0f - to.z, 16.0f - to.y, 16.0f - from.z, 16.0f - from.y};
            }
        }
        return null;
    }

    public static IModel getModel(ResourceLocation location) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            if (model == null) {
                ModCharset.logger.error("Model " + location.toString() + " is missing! THIS WILL CAUSE A CRASH!");
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IModel getModelWithTextures(ResourceLocation location, TextureMap map) {
        IModel model = RenderUtils.getModel(location);
        if (model != null) {
            for (ResourceLocation tlocation : model.getTextures()) {
                map.func_174942_a(tlocation);
            }
        }
        return model;
    }

    private static int getSelectionMask(int y, int x, int z) {
        return 1 << y * 4 + x * 2 + z;
    }

    private static void drawLine(BufferBuilder worldrenderer, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        worldrenderer.func_181662_b(x1, y1, z1).func_181675_d();
        worldrenderer.func_181662_b(x2, y2, z2).func_181675_d();
    }

    public static int getSelectionMask(EnumFacing face) {
        int lineMask = 0;
        switch (face) {
            case DOWN: {
                return 15;
            }
            case UP: {
                return 3840;
            }
            case NORTH: {
                lineMask |= RenderUtils.getSelectionMask(1, 0, 0);
                lineMask |= RenderUtils.getSelectionMask(1, 1, 0);
                lineMask |= RenderUtils.getSelectionMask(0, 0, 0);
                return lineMask |= RenderUtils.getSelectionMask(2, 0, 0);
            }
            case SOUTH: {
                lineMask |= RenderUtils.getSelectionMask(1, 0, 1);
                lineMask |= RenderUtils.getSelectionMask(1, 1, 1);
                lineMask |= RenderUtils.getSelectionMask(0, 0, 1);
                return lineMask |= RenderUtils.getSelectionMask(2, 0, 1);
            }
            case WEST: {
                lineMask |= RenderUtils.getSelectionMask(1, 0, 0);
                lineMask |= RenderUtils.getSelectionMask(1, 0, 1);
                lineMask |= RenderUtils.getSelectionMask(0, 1, 0);
                return lineMask |= RenderUtils.getSelectionMask(2, 1, 0);
            }
            case EAST: {
                lineMask |= RenderUtils.getSelectionMask(1, 1, 0);
                lineMask |= RenderUtils.getSelectionMask(1, 1, 1);
                lineMask |= RenderUtils.getSelectionMask(0, 1, 1);
                return lineMask |= RenderUtils.getSelectionMask(2, 1, 1);
            }
        }
        return lineMask;
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB box, int lineMask) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        AxisAlignedBB boundingBox = box.func_186662_g((double)0.002f).func_72317_d(-playerX, -playerY, -playerZ);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        if ((lineMask & RenderUtils.getSelectionMask(0, 0, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        }
        if ((lineMask & RenderUtils.getSelectionMask(0, 0, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(0, 1, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(0, 1, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(1, 0, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & RenderUtils.getSelectionMask(1, 0, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(1, 1, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & RenderUtils.getSelectionMask(1, 1, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(2, 0, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & RenderUtils.getSelectionMask(2, 0, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(2, 1, 0)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & RenderUtils.getSelectionMask(2, 1, 1)) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static int multiplyColor(int src, int dst) {
        int out = 0;
        for (int i = 0; i < 32; i += 8) {
            out |= ((src >> i & 0xFF) * (dst >> i & 0xFF) / 255 & 0xFF) << i;
        }
        return out;
    }

    public static enum AveragingMode {
        FULL,
        H_EDGES_ONLY,
        V_EDGES_ONLY;

    }
}

