/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import mcmultipart.api.item.ItemBlockMultipart;
import mcmultipart.api.multipart.IMultipart;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.TileWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

public class ItemWire
extends ItemBlockMultipart {
    public ItemWire(Block block) {
        super(block, (IMultipart)block);
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack stack) {
        Wire wire = this.fromStack(new IWireContainer.Dummy(), stack, EnumFacing.DOWN);
        String tr = "tile.wire.null";
        if (wire != null) {
            String name = wire.getDisplayName();
            tr = "tile." + (wire.getLocation() == WireFace.CENTER ? name + ".freestanding" : name) + ".name";
        }
        return I18n.func_74838_a((String)tr);
    }

    public Wire fromStack(IWireContainer container, ItemStack stack, EnumFacing facing) {
        WireProvider factory = (WireProvider)WireManager.REGISTRY.getValue(stack.func_77960_j() >> 1);
        if (factory != null) {
            WireFace location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing);
            return factory.create(container, location);
        }
        return null;
    }

    public ItemStack toStack(WireProvider provider, boolean freestanding, int amount) {
        return new ItemStack((Item)this, amount, WireManager.REGISTRY.getID((IForgeRegistryEntry)provider) << 1 | (freestanding ? 1 : 0));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemWire.place((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)hand, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ, (Item)this, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8) -> ((Block)this.field_150939_a).getStateForPlacement(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6, arg_7, arg_8), (IMultipart)this.multipartBlock, this::placeBlockAtTested, this::placeWirePartAt);
    }

    public boolean placeWirePartAt(ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IMultipart multipartBlock, IBlockState state) {
        WireFace location;
        WireProvider factory = (WireProvider)WireManager.REGISTRY.getValue(stack.func_77960_j() >> 1);
        WireFace wireFace = location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing.func_176734_d());
        if (!factory.canPlace((IBlockAccess)world, pos, location)) {
            return false;
        }
        return ItemBlockMultipart.placePartAt((ItemStack)stack, (EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ, (IMultipart)multipartBlock, (IBlockState)state);
    }

    public boolean placeBlockAtTested(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState newState) {
        WireFace location;
        WireProvider factory = (WireProvider)WireManager.REGISTRY.getValue(stack.func_77960_j() >> 1);
        WireFace wireFace = location = (stack.func_77960_j() & 1) != 0 ? WireFace.CENTER : WireFace.get(facing.func_176734_d());
        if (!factory.canPlace((IBlockAccess)world, pos, location)) {
            return false;
        }
        if (factory.canProvidePower()) {
            newState = newState.func_177226_a((IProperty)BlockWire.REDSTONE, (Comparable)Boolean.valueOf(true));
        }
        if (super.placeBlockAtTested(stack, player, world, pos, facing, hitX, hitY, hitZ, newState)) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileWire) {
                ((TileWire)tileEntity).onPlacedBy(WireFace.get(facing != null ? facing.func_176734_d() : null), stack);
            }
            return true;
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (WireProvider provider : WireManager.REGISTRY.getValues()) {
                int id = WireManager.REGISTRY.getID((IForgeRegistryEntry)provider);
                if (provider.hasSidedWire()) {
                    subItems.add((Object)new ItemStack((Item)this, 1, id * 2));
                }
                if (!provider.hasFreestandingWire()) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, id * 2 + 1));
            }
        }
    }
}

