/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.charset.lib.render.sprite.SpritesheetFactory;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.lib.wires.CharsetLibWires;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;

public class RendererWire
extends ModelFactory<Wire> {
    private final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private final TIntObjectMap<Wire> stackMap = new TIntObjectHashMap();
    private final Map<WireProvider, WireSheet> sheetMap = new HashMap<WireProvider, WireSheet>();

    public RendererWire() {
        super(Wire.PROPERTY, new ResourceLocation("minecraft:blocks/stone"));
        this.addDefaultBlockTransforms();
    }

    public WireSheet getSheet(WireProvider type) {
        return this.sheetMap.get(type);
    }

    public void registerSheet(TextureMap map, WireProvider type) {
        ResourceLocation location = type.getTexturePrefix();
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        if (!path.endsWith("/")) {
            path = path + "_";
        }
        WireSheet sheet = new WireSheet(map, domain, path, type);
        this.sheetMap.put(type, sheet);
    }

    private boolean wc(Wire wire, EnumFacing facing) {
        return wire.connects(facing);
    }

    private boolean isCenterEdge(Wire wire, WireFace side) {
        return false;
    }

    private float getCL(Wire wire, WireFace side) {
        float h = 0.0f;
        if (wire != null && this.isCenterEdge(wire, side)) {
            h = 0.0f;
        }
        if (!this.wc(wire, side.facing) && wire.getFactory() != null) {
            h = 8.0f - (float)(this.sheetMap.get((Object)wire.getFactory()).width / 2);
        }
        return side.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 16.0f - h : h;
    }

    public void addWireFreestanding(Wire wire, WireSheet sheet, int renderColor, List<BakedQuad> quads) {
        float min = 8.0f - (float)(sheet.width / 2);
        float max = 8.0f + (float)(sheet.width / 2);
        Vector3f minX = new Vector3f(min, this.getCL(wire, WireFace.DOWN), this.getCL(wire, WireFace.NORTH));
        Vector3f maxX = new Vector3f(min, this.getCL(wire, WireFace.UP), this.getCL(wire, WireFace.SOUTH));
        Vector3f minY = new Vector3f(this.getCL(wire, WireFace.WEST), min, this.getCL(wire, WireFace.NORTH));
        Vector3f maxY = new Vector3f(this.getCL(wire, WireFace.EAST), min, this.getCL(wire, WireFace.SOUTH));
        Vector3f minZ = new Vector3f(this.getCL(wire, WireFace.WEST), this.getCL(wire, WireFace.DOWN), min);
        Vector3f maxZ = new Vector3f(this.getCL(wire, WireFace.EAST), this.getCL(wire, WireFace.UP), min);
        int cmcX = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.NORTH) ? 2 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 1 : 0);
        int cmcY = (this.wc(wire, EnumFacing.NORTH) ? 4 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 8 : 0) | (this.wc(wire, EnumFacing.WEST) ? 2 : 0) | (this.wc(wire, EnumFacing.EAST) ? 1 : 0);
        int cmcZ = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.WEST) ? 1 : 0) | (this.wc(wire, EnumFacing.EAST) ? 2 : 0);
        for (int i = 0; i < 2; ++i) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minX, maxX, renderColor, sheet.top[cmcX], i == 0 ? EnumFacing.WEST : EnumFacing.EAST, ModelRotation.X0_Y0, true));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minY, maxY, renderColor, sheet.top[cmcY], i == 0 ? EnumFacing.DOWN : EnumFacing.UP, ModelRotation.X0_Y0, true));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minZ, maxZ, renderColor, sheet.top[cmcZ], i == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH, ModelRotation.X0_Y0, true));
            if (i != 0) continue;
            minX.setX(max);
            maxX.setX(max);
            minY.setY(max);
            maxY.setY(max);
            minZ.setZ(max);
            maxZ.setZ(max);
            cmcY = cmcY & 3 | (cmcY & 8) >> 1 | (cmcY & 4) << 1;
            cmcZ = cmcZ & 0xC | (cmcZ & 2) >> 1 | (cmcZ & 1) << 1;
            cmcX = cmcX & 0xC | (cmcX & 2) >> 1 | (cmcX & 1) << 1;
        }
        if (sheet.edge != null) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                float[] fArray;
                if (!this.wc(wire, f)) continue;
                Vector3f vector3f = new Vector3f(min, 0.0f, min);
                Vector3f vector3f2 = new Vector3f(max, 0.0f, max);
                if (f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                    float[] fArray2 = new float[4];
                    fArray2[0] = max;
                    fArray2[1] = min;
                    fArray2[2] = min;
                    fArray = fArray2;
                    fArray2[3] = max;
                } else {
                    float[] fArray3 = new float[4];
                    fArray3[0] = min;
                    fArray3[1] = min;
                    fArray3[2] = max;
                    fArray = fArray3;
                    fArray3[3] = max;
                }
                quads.add(RenderUtils.BAKERY.makeBakedQuad(vector3f, vector3f2, renderColor, fArray, sheet.edge, EnumFacing.DOWN, this.ROTATIONS[f.ordinal()], true));
            }
        }
    }

    public void addCorner(Wire wire, WireSheet sheet, EnumFacing dir, int renderColor, List<BakedQuad> quads) {
        if (wire.getFactory().isFlat()) {
            return;
        }
        int width = sheet.width;
        int height = sheet.height;
        ModelRotation rot = this.ROTATIONS[wire.getLocation().ordinal()];
        float min = 8.0f - (float)(width / 2);
        float max = 8.0f + (float)(width / 2);
        float[] edgeUV = new float[]{min, 0.0f, max, height};
        float[] edgeUVFlipped = new float[]{max, 0.0f, min, height};
        if (dir == EnumFacing.NORTH) {
            float[] topUV = new float[]{min, 16 - height, max, 16.0f};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(max, (float)height, (float)(-height)), renderColor, edgeUVFlipped, sheet.top[15], EnumFacing.NORTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, (float)height, (float)(-height)), new Vector3f(max, (float)height, 0.0f), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            if (sheet.edge != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(min, (float)height, 0.0f), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(max, 0.0f, (float)(-height)), new Vector3f(max, (float)height, 0.0f), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
            }
        } else if (dir == EnumFacing.SOUTH) {
            float[] topUV = new float[]{min, 0.0f, max, height};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(16 + height)), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, edgeUVFlipped, sheet.top[15], EnumFacing.SOUTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, (float)height, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            if (sheet.edge != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, 16.0f), new Vector3f(min, (float)height, (float)(16 + height)), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(max, 0.0f, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
            }
        } else if (dir == EnumFacing.WEST) {
            float[] topUV = new float[]{16 - height, min, 16.0f, max};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), (float)height, min), new Vector3f(0.0f, (float)height, max), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f((float)(-height), (float)height, max), renderColor, edgeUV, sheet.top[15], EnumFacing.WEST, rot, false));
            if (sheet.edge != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f(0.0f, (float)height, min), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, max), new Vector3f(0.0f, (float)height, max), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
            }
        } else if (dir == EnumFacing.EAST) {
            float[] topUV = new float[]{0.0f, min, height, max};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, (float)height, min), new Vector3f((float)(16 + height), (float)height, max), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(16 + height), 0.0f, min), new Vector3f((float)(16 + height), (float)height, max), renderColor, edgeUV, sheet.top[15], EnumFacing.EAST, rot, false));
            if (sheet.edge != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, 0.0f, min), new Vector3f((float)(16 + height), (float)height, min), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, 0.0f, max), new Vector3f((float)(16 + height), (float)height, max), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
            }
        }
    }

    public void addWire(Wire wire, WireSheet sheet, List<BakedQuad> quads) {
        WireFace side = wire.getLocation();
        int renderColor = wire.getRenderColor();
        if (side == WireFace.CENTER) {
            this.addWireFreestanding(wire, sheet, renderColor, quads);
            return;
        }
        float min = 8.0f - (float)(sheet.width / 2);
        float max = 8.0f + (float)(sheet.width / 2);
        float minH = 0.0f;
        float maxH = sheet.height;
        EnumFacing[] dirs = WireUtils.getConnectionsForRender(side);
        boolean[] connectionMatrix = new boolean[]{wire == null || wire.connectsAny(dirs[0]), wire == null || wire.connectsAny(dirs[1]), wire == null || wire.connectsAny(dirs[2]), wire == null || wire.connectsAny(dirs[3])};
        int cmc = (connectionMatrix[0] ? 8 : 0) | (connectionMatrix[1] ? 4 : 0) | (connectionMatrix[2] ? 2 : 0) | (connectionMatrix[3] ? 1 : 0);
        boolean[] cornerConnectionMatrix = new boolean[]{wire == null || wire.connectsCorner(dirs[0]), wire == null || wire.connectsCorner(dirs[1]), wire == null || wire.connectsCorner(dirs[2]), wire == null || wire.connectsCorner(dirs[3])};
        ModelRotation rot = this.ROTATIONS[side.ordinal()];
        Vector3f from = new Vector3f(min, (float)sheet.height, min);
        Vector3f to = new Vector3f(max, (float)sheet.height, max);
        if (connectionMatrix[0]) {
            from.setZ(0.0f);
        }
        if (connectionMatrix[1]) {
            to.setZ(16.0f);
        }
        if (connectionMatrix[2]) {
            from.setX(0.0f);
        }
        if (connectionMatrix[3]) {
            to.setX(16.0f);
        }
        quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, renderColor, new float[]{from.getX(), from.getZ(), to.getX(), to.getZ()}, sheet.top[cmc], EnumFacing.UP, rot, true));
        if (!wire.getFactory().isFlat()) {
            boolean crossroadsZ;
            from.setY(0.0f);
            to.setY(0.0f);
            quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, renderColor, new float[]{from.getX(), from.getZ(), to.getX(), to.getZ()}, sheet.top[cmc], EnumFacing.DOWN, rot, true));
            Vector3f fromZ = new Vector3f(from.getX(), 0.0f, min);
            Vector3f toZ = new Vector3f(to.getX(), (float)sheet.height, min);
            Vector3f fromX = new Vector3f(min, 0.0f, from.getZ());
            Vector3f toX = new Vector3f(min, (float)sheet.height, to.getZ());
            boolean crossroadsX = connectionMatrix[2] && !connectionMatrix[3];
            boolean bl = crossroadsZ = connectionMatrix[0] && !connectionMatrix[1];
            if (sheet.side != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(fromX, toX, renderColor, new float[]{fromX.getZ(), fromX.getY(), toX.getZ(), toX.getY()}, sheet.side, EnumFacing.WEST, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(fromZ, toZ, renderColor, new float[]{toZ.getX(), fromZ.getY(), fromZ.getX(), toZ.getY()}, sheet.side, EnumFacing.NORTH, rot, false));
            }
            fromX.setX(max);
            toX.setX(max);
            fromZ.setZ(max);
            toZ.setZ(max);
            if (sheet.side != null) {
                quads.add(RenderUtils.BAKERY.makeBakedQuad(fromX, toX, renderColor, new float[]{toX.getZ(), fromX.getY(), fromX.getZ(), toX.getY()}, sheet.side, EnumFacing.EAST, rot, false));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(fromZ, toZ, renderColor, new float[]{fromZ.getX(), fromZ.getY(), toZ.getX(), toZ.getY()}, sheet.side, EnumFacing.SOUTH, rot, false));
            }
            float[] edgeUV = new float[]{min, minH, max, maxH};
            float[] edgeUVFlipped = new float[]{max, minH, min, maxH};
            if (sheet.edge != null) {
                if (connectionMatrix[0]) {
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, minH, 0.0f), new Vector3f(max, maxH, 0.0f), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
                }
                if (connectionMatrix[1]) {
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, minH, 16.0f), new Vector3f(max, maxH, 16.0f), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
                }
                if (connectionMatrix[2]) {
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(0.0f, minH, min), new Vector3f(0.0f, maxH, max), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
                }
                if (connectionMatrix[3]) {
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, minH, min), new Vector3f(16.0f, maxH, max), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
                }
            }
            EnumFacing[] dirs0 = WireUtils.getConnectionsForRender(WireFace.DOWN);
            for (int i = 0; i < 4; ++i) {
                if (!cornerConnectionMatrix[i]) continue;
                this.addCorner(wire, sheet, dirs0[i], renderColor, quads);
            }
        }
    }

    @Override
    public IBakedModel bake(Wire wire, boolean isItem, BlockRenderLayer layer) {
        WireSheet sheet;
        SimpleBakedModel model = new SimpleBakedModel(this);
        if (wire != null && (sheet = this.sheetMap.get(wire.getFactory())) != null) {
            model.setParticle(sheet.particle);
            this.addWire(wire, sheet, model.func_188616_a(null, null, 0L));
        }
        return model;
    }

    @Override
    public Wire fromItemStack(ItemStack stack) {
        int md = stack.func_77952_i();
        if (this.stackMap.containsKey(md)) {
            return (Wire)this.stackMap.get(md);
        }
        Wire wire = CharsetLibWires.itemWire.fromStack(new IWireContainer.Dummy(), stack, EnumFacing.DOWN);
        if (wire != null) {
            wire.setConnectionsForItemRender();
            this.stackMap.put(md, (Object)wire);
            return wire;
        }
        return null;
    }

    public static class WireSheet {
        @Nonnull
        final TextureAtlasSprite[] top;
        @Nullable
        final TextureAtlasSprite side;
        @Nullable
        final TextureAtlasSprite edge;
        @Nonnull
        final TextureAtlasSprite particle;
        final int width;
        final int height;

        private WireSheet(TextureMap map, String domain, String path, WireProvider type) {
            this.top = SpritesheetFactory.register(map, new ResourceLocation(domain, path + "top"), 4, 4);
            this.particle = map.func_174942_a(new ResourceLocation(domain, path + "particle"));
            if (!type.isFlat()) {
                this.edge = map.func_174942_a(new ResourceLocation(domain, path + "edge"));
                this.side = map.func_174942_a(new ResourceLocation(domain, path + "side"));
            } else {
                this.edge = null;
                this.side = null;
            }
            this.width = (int)(type.getWidth() * 16.0f);
            this.height = (int)(type.getHeight() * 16.0f);
        }
    }
}

