/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.storage.system.DataStorage;

public class ItemQuartzDisc
extends Item {
    public static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_SIZE = 2880000;

    public ItemQuartzDisc() {
        this.func_77655_b("charset.quartz_disc");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        int size = stack.func_77942_o() && stack.func_77978_p().func_74764_b("size") ? stack.func_77978_p().func_74762_e("size") : 2880000;
        int sizeSec = size / 6000;
        int sizeMin = sizeSec / 60;
        CharsetAudioStorage.addTimeToTooltip(tooltip, sizeMin, sizeSec %= 60);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    public static class CapabilityProvider
    implements INBTSerializable<NBTTagCompound>,
    ICapabilityProvider {
        private final ItemStack stack;
        private final IDataStorage dataStorage;

        public CapabilityProvider(ItemStack stack) {
            this.stack = stack;
            this.dataStorage = (IDataStorage)CharsetAudioStorage.DATA_STORAGE.getDefaultInstance();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CharsetAudioStorage.DATA_STORAGE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.dataStorage != null) {
                if (!this.dataStorage.isInitialized()) {
                    this.dataStorage.initialize(null, 0, this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b("size") ? this.stack.func_77978_p().func_74762_e("size") : 2880000);
                }
                if (capability == CharsetAudioStorage.DATA_STORAGE) {
                    if (!((DataStorage)this.dataStorage).initializeContents()) {
                        return null;
                    }
                    return (T)CharsetAudioStorage.DATA_STORAGE.cast((Object)this.dataStorage);
                }
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            if (this.dataStorage != null) {
                NBTTagCompound compound = new NBTTagCompound();
                NBTBase data = CharsetAudioStorage.DATA_STORAGE.writeNBT((Object)this.dataStorage, null);
                if (data != null) {
                    compound.func_74782_a("data", data);
                }
                return compound;
            }
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (this.dataStorage != null && nbt.func_74764_b("data")) {
                CharsetAudioStorage.DATA_STORAGE.readNBT((Object)this.dataStorage, null, (NBTBase)nbt.func_74775_l("data"));
            }
        }
    }
}

