/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage.system;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;

public class DataStorage
implements IDataStorage {
    private String uniqueId;
    private File file;
    private int size;
    private byte[] data;
    private int position;
    private boolean dirty;

    @Override
    public boolean isInitialized() {
        return this.data != null;
    }

    public boolean initializeContents() {
        if (this.file == null && CharsetAudioStorage.storageManager.isReady()) {
            this.file = CharsetAudioStorage.storageManager.getFileForId(this.uniqueId);
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                    this.writeFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.readFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.file != null;
    }

    @Override
    public void initialize(String id, int position, int size) {
        this.uniqueId = id == null || id.length() == 0 ? CharsetAudioStorage.storageManager.generateUID() : id;
        this.position = position;
        this.size = size;
        this.data = new byte[size];
        if (this.position >= size) {
            this.position = size - 1;
        } else if (this.position < 0) {
            this.position = 0;
        }
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int setPosition(int newPosition) {
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition >= this.size) {
            newPosition = this.size - 1;
        }
        this.position = newPosition;
        return newPosition;
    }

    public int trySeek(int dir) {
        int oldPosition = this.position;
        int newPosition = this.position + dir;
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition >= this.size) {
            newPosition = this.size - 1;
        }
        return newPosition - oldPosition;
    }

    @Override
    public int seek(int dir) {
        int seek = this.trySeek(dir);
        this.position += seek;
        return seek;
    }

    @Override
    public int read(boolean simulate) {
        if (this.position >= this.size) {
            return 0;
        }
        if (simulate) {
            return this.data[this.position] & 0xFF;
        }
        return this.data[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] v, int offset, boolean simulate) {
        int len = Math.min(this.size - (this.position + offset) - 1, v.length);
        System.arraycopy(this.data, this.position + offset, v, 0, len);
        if (!simulate) {
            this.position += len;
        }
        return len;
    }

    @Override
    public int read(byte[] v, boolean simulate) {
        return this.read(v, 0, simulate);
    }

    @Override
    public void write(byte v) {
        if (this.position >= this.size) {
            return;
        }
        this.dirty = true;
        this.data[this.position++] = v;
    }

    @Override
    public int write(byte[] v) {
        int len = Math.min(this.size - this.position - 1, v.length);
        if (len == 0) {
            return 0;
        }
        System.arraycopy(v, 0, this.data, this.position, len);
        this.position += len;
        this.dirty = true;
        return len;
    }

    void readFile() throws IOException {
        CharsetAudioStorage.storageManager.save();
        FileInputStream fileStream = new FileInputStream(this.file);
        GZIPInputStream stream = new GZIPInputStream(fileStream);
        int version = stream.read();
        if (version == 1) {
            int b1 = stream.read() & 0xFF;
            int b2 = stream.read() & 0xFF;
            int b3 = stream.read() & 0xFF;
            int b4 = stream.read() & 0xFF;
            this.position = b1 | b2 << 8 | b3 << 16 | b4 << 24;
            if (this.position < 0 || this.position >= this.size) {
                this.position = 0;
            }
        }
        try {
            int s;
            for (int dataPos = 0; dataPos < this.data.length && (s = stream.read(this.data, dataPos, this.data.length - dataPos)) >= 0; dataPos += s) {
            }
        }
        catch (EOFException e) {
            ModCharset.logger.warn("Audio file " + this.getUniqueId() + " might have been corrupted.");
            this.dirty = true;
        }
        stream.close();
        fileStream.close();
    }

    void writeFile() throws IOException {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            FileOutputStream fileStream = new FileOutputStream(this.file);
            GZIPOutputStream stream = new GZIPOutputStream(fileStream);
            stream.write(2);
            stream.write(this.data);
            stream.finish();
            stream.flush();
            stream.close();
            fileStream.close();
            this.dirty = false;
        }
    }

    @Override
    public void onUnload() throws IOException {
        if (this.dirty) {
            CharsetAudioStorage.storageManager.markSaveNeeded(this);
        }
    }
}

