/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage.system;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.codec.binary.Hex;
import pl.asie.charset.ModCharset;
import pl.asie.charset.module.audio.storage.system.DataStorage;

public class DataStorageManager {
    private static final Random rand = new Random();
    private final Map<String, DataStorage> dirtyMap = new HashMap<String, DataStorage>();
    private long lastSave = 0L;
    private File saveDir;

    public DataStorageManager() {
        File saveDirParent = new File(DimensionManager.getCurrentSaveRootDirectory(), "charset");
        if (saveDirParent.exists() || saveDirParent.mkdir()) {
            this.saveDir = new File(saveDirParent, "data_storage");
            if (!this.saveDir.exists() && !this.saveDir.mkdir()) {
                ModCharset.logger.error("Could not create save directory! " + saveDirParent.getAbsolutePath());
            }
        } else {
            ModCharset.logger.error("Could not create save directory! " + saveDirParent.getAbsolutePath());
        }
        this.lastSave = this.getCurrentTime();
    }

    private long getCurrentTime() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            boolean shouldStore;
            Map<String, DataStorage> map = this.dirtyMap;
            synchronized (map) {
                shouldStore = this.dirtyMap.size() > 0;
            }
            if (shouldStore && this.lastSave + 30000L < this.getCurrentTime()) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markSaveNeeded(DataStorage impl) {
        if (impl.getUniqueId() != null) {
            Map<String, DataStorage> map = this.dirtyMap;
            synchronized (map) {
                this.dirtyMap.put(impl.getUniqueId(), impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        HashSet<DataStorage> dirtySetClone = new HashSet<DataStorage>();
        Map<String, DataStorage> map = this.dirtyMap;
        synchronized (map) {
            dirtySetClone.addAll(this.dirtyMap.values());
            this.dirtyMap.clear();
        }
        for (DataStorage impl : dirtySetClone) {
            impl.writeFile();
        }
    }

    private String filename(String storageName) {
        return storageName + ".dat";
    }

    String generateUID() {
        for (int j = 16; j <= 32; ++j) {
            for (int i = 0; i < 256; ++i) {
                byte[] nameHex = new byte[j];
                rand.nextBytes(nameHex);
                String name = Hex.encodeHexString((byte[])nameHex);
                if (this.exists(name)) continue;
                return name;
            }
            ++j;
        }
        return null;
    }

    public boolean exists(String name) {
        return this.getFileForId(name).exists();
    }

    public boolean isReady() {
        return this.saveDir != null;
    }

    public File getFileForId(String name) {
        return new File(this.saveDir, this.filename(name));
    }
}

