/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.transport;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;

public class WireAudioCable
extends Wire
implements IAudioReceiver {
    private final Set<AudioPacket> receivedPackets = new HashSet<AudioPacket>();
    private long lastReceivedTime = -1L;

    public WireAudioCable(IWireContainer container, WireProvider factory, WireFace location) {
        super(container, factory, location);
    }

    @Override
    public boolean canConnectBlock(BlockPos pos, EnumFacing direction) {
        return WireUtils.hasCapability(this, pos, Capabilities.AUDIO_SOURCE, direction, true) || WireUtils.hasCapability(this, pos, Capabilities.AUDIO_RECEIVER, direction, true);
    }

    @Override
    public boolean receive(AudioPacket packet) {
        if (this.lastReceivedTime != this.getContainer().world().func_82737_E()) {
            this.lastReceivedTime = this.getContainer().world().func_82737_E();
            this.receivedPackets.clear();
        }
        if (this.receivedPackets.contains(packet)) {
            return false;
        }
        this.receivedPackets.add(packet);
        boolean received = false;
        for (IAudioReceiver receiver : this.connectedIterator(Capabilities.AUDIO_RECEIVER, true)) {
            received |= receiver.receive(packet);
        }
        return received;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == Capabilities.AUDIO_RECEIVER) {
            return this.connects(facing) || this.getLocation().facing != null && this.getLocation().facing == facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.AUDIO_RECEIVER && (this.connects(facing) || this.getLocation().facing != null && this.getLocation().facing == facing)) {
            return (T)Capabilities.AUDIO_RECEIVER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String getDisplayName() {
        return "charset.audioCable";
    }
}

