/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.blocks.TileReflector;

public class BlockReflector
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyDirection ROTATION = PropertyDirection.func_177714_a((String)"rotation");
    public static final PropertyBool SPLITTER = PropertyBool.func_177716_a((String)"splitter");
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOX;
    }

    @Nonnull
    public static EnumFacing getTargetFacing(@Nonnull EnumFacing facing, @Nonnull EnumFacing rotation) {
        if (facing.func_176740_k() == rotation.func_176740_k()) {
            return facing.func_176734_d();
        }
        switch (rotation.func_176740_k()) {
            case Y: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                rotation = rotation.func_176734_d();
                break;
            }
            case X: 
            case Z: {
                if (facing.func_176740_k() != EnumFacing.Axis.Y) break;
                rotation = rotation.func_176734_d();
            }
        }
        switch (rotation) {
            case DOWN: {
                return facing.func_176735_f();
            }
            case UP: {
                return facing.func_176746_e();
            }
            case NORTH: {
                return facing.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Z);
            }
            case SOUTH: {
                return facing.func_176732_a(EnumFacing.Axis.Z);
            }
            case WEST: {
                return facing.func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.X);
            }
            case EAST: {
                return facing.func_176732_a(EnumFacing.Axis.X);
            }
        }
        throw new RuntimeException("Should never reach here!");
    }

    public BlockReflector() {
        super(Material.field_151592_s);
        this.setOpaqueCube(false);
        this.setFullCube(false);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, SPLITTER, CharsetLaser.LASER_COLOR});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)SPLITTER, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)ROTATION)).ordinal() | ((Boolean)state.func_177229_b((IProperty)SPLITTER) != false ? 8 : 0);
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (int i = 0; i <= 16; ++i) {
            if ((i & 7) <= 0) continue;
            itemList.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing facing;
        IBlockState state = world.func_180495_p(pos);
        EnumFacing newFacing = facing = (EnumFacing)state.func_177229_b((IProperty)ROTATION);
        newFacing = facing.func_176740_k() == axis.func_176740_k() ? facing.func_176734_d() : axis;
        if (facing != newFacing) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)ROTATION, (Comparable)newFacing));
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileReflector) {
                ((TileReflector)tile).updateRotations();
            }
        }
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileReflector();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileReflector) {
            return state.func_177226_a(CharsetLaser.LASER_COLOR, (Comparable)((Object)((TileReflector)tile).getColor()));
        }
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)SPLITTER, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)ROTATION);
        int count = RotationUtils.getClockwiseRotationCount(rot);
        block4: for (int i = 0; i < count; ++i) {
            switch (facing) {
                case DOWN: 
                case UP: {
                    facing = facing.func_176734_d();
                    continue block4;
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    facing = facing.func_176746_e();
                }
            }
        }
        return state.func_177226_a((IProperty)ROTATION, (Comparable)facing);
    }
}

