/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.laser.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.laser.LaserColor;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.module.laser.CharsetLaser;
import pl.asie.charset.module.laser.blocks.BlockCrystal;
import pl.asie.charset.module.laser.blocks.TileLaserSourceBase;
import pl.asie.charset.module.laser.system.LaserBeam;
import pl.asie.charset.module.laser.system.LaserSource;

public class TileCrystal
extends TileLaserSourceBase {
    protected final LaserColor[] newColors = new LaserColor[6];
    private ILaserReceiver[] receivers = new ILaserReceiver[6];
    private LaserColor color;
    private long updateQueued = -1L;
    private int hitMask = 0;
    private int newHitMask = 0;

    @Override
    public ItemStack getDroppedBlock(IBlockState state) {
        if (state.func_177230_c() == CharsetLaser.blockCrystal) {
            return new ItemStack(CharsetLaser.blockCrystal, 1, ((LaserColor)((Object)state.func_177229_b(CharsetLaser.LASER_COLOR))).ordinal());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected LaserSource createLaserSource(final int i) {
        return new LaserSource(this){

            @Override
            public void updateBeam() {
                LaserColor c = LaserColor.NONE;
                if (TileCrystal.this.hitMask == 0) {
                    c = TileCrystal.this.colors[i];
                }
                if (c == LaserColor.NONE) {
                    this.beam = null;
                } else if (this.beam == null || !this.beam.isValid() || !this.beam.getStart().equals((Object)TileCrystal.this.func_174877_v()) || this.beam.getColor() != c) {
                    this.beam = new LaserBeam(TileCrystal.this, EnumFacing.func_82600_a((int)i), c);
                }
            }
        };
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.hitMask = 0;
        for (int i = 0; i < 6; ++i) {
            this.receivers[i] = null;
        }
    }

    private void updateOpacity(EnumFacing facing, IBlockState oldState, LaserColor colorHit, boolean force) {
        if (!force) {
            if (oldState == null) {
                oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
            }
            boolean bl = force = (Boolean)oldState.func_177229_b((IProperty)BlockCrystal.OPAQUE) != (this.newHitMask != 0);
        }
        if (force) {
            if (this.updateQueued != this.field_145850_b.func_82737_E()) {
                Scheduler.INSTANCE.in(this.field_145850_b, 0, () -> {
                    IBlockState oldState2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    if (oldState2.func_177230_c() instanceof BlockCrystal && (Boolean)oldState2.func_177229_b((IProperty)BlockCrystal.OPAQUE) != (this.newHitMask != 0)) {
                        this.hitMask = this.newHitMask;
                        IBlockState newState = oldState2.func_177226_a((IProperty)BlockCrystal.OPAQUE, (Comparable)Boolean.valueOf(this.hitMask != 0));
                        this.field_145850_b.func_175656_a(this.field_174879_c, newState);
                        for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                            this.colors[facing2.ordinal()] = this.newColors[facing2.ordinal()];
                            CharsetLaser.laserStorage.markLaserForUpdate(this, facing2);
                        }
                        for (int i = 0; i < 6; ++i) {
                            this.receivers[i].onLaserUpdate(this.colors[i ^ 1]);
                        }
                        if (this.hitMask != this.newHitMask) {
                            ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.SMOKE_NORMAL, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.1, 0.1, 0.1, 0.05, new int[0]);
                        }
                    }
                });
            }
            this.updateQueued = this.field_145850_b.func_82737_E();
        } else {
            this.hitMask = this.newHitMask;
            if (facing != null) {
                this.colors[facing.ordinal()] = colorHit;
                CharsetLaser.laserStorage.markLaserForUpdate(this, facing);
            }
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (int i = 0; i < 6; ++i) {
            int _i = i;
            this.newColors[i] = LaserColor.NONE;
            this.receivers[i] = colorHit -> {
                IBlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.color = (LaserColor)((Object)((Object)oldState.func_177229_b(CharsetLaser.LASER_COLOR)));
                this.newHitMask = this.hitMask == 0 ? (((colorHit.ordinal() | this.newColors[_i].ordinal()) & this.color.ordinal()) == this.color.ordinal() ? (this.newHitMask |= 3 << (_i & 6)) : (this.newHitMask &= ~(3 << (_i & 6)))) : ((colorHit.ordinal() & this.color.ordinal()) == this.color.ordinal() ? (this.newHitMask |= 1 << _i) : (this.newHitMask &= ~(1 << _i)));
                if (this.newColors[_i ^ 1] != colorHit) {
                    this.newColors[_i ^ 1] = colorHit;
                    this.updateOpacity(EnumFacing.func_82600_a((int)(_i ^ 1)), oldState, colorHit, false);
                } else {
                    this.updateOpacity(null, oldState, colorHit, false);
                }
            };
        }
        this.updateOpacity(null, null, null, true);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && capability == CharsetLaser.LASER_RECEIVER && this.receivers[facing.ordinal()] != null || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CharsetLaser.LASER_RECEIVER) {
            return (T)CharsetLaser.LASER_RECEIVER.cast((Object)this.receivers[facing.ordinal()]);
        }
        return super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            return true;
        }
        if (oldState.func_177230_c() instanceof BlockCrystal) {
            return oldState.func_177229_b(CharsetLaser.LASER_COLOR) != newState.func_177229_b(CharsetLaser.LASER_COLOR);
        }
        return false;
    }
}

